/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.mutex;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;

public class Mutex {
    private String name;
    protected boolean inUse;
    protected int nbOwners;
    private boolean debug;

    protected Mutex(String name) {
        this.name = name;
        this.inUse = false;
        this.debug = false;
        this.nbOwners = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mutex acquire(String who) throws InterruptedException {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Trying to acquire mutex " + this.name);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            try {
                while (this.inUse) {
                    this.wait();
                }
                if (this.nbOwners != 0) {
                    throw new InterruptedException("nb owners != 0 - " + this.nbOwners);
                }
                this.inUse = true;
                ++this.nbOwners;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Mutex " + this.name + " acquired!");
        }
        return this;
    }

    public synchronized void release(String who) {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Releasing mutex " + this.name);
        }
        this.inUse = false;
        --this.nbOwners;
        if (this.nbOwners < 0) {
            throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Nb owner is negative in release(" + who + ")"));
        }
        this.notify();
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - Trying to acquire mutex " + this.name);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            if (!this.inUse) {
                this.inUse = true;
                ++this.nbOwners;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = OdbTime.getCurrentTimeInMs();
            try {
                do {
                    this.wait(waitTime);
                    if (this.inUse) continue;
                    this.inUse = true;
                    ++this.nbOwners;
                    return true;
                } while ((waitTime = msecs - (OdbTime.getCurrentTimeInMs() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public int getNbOwners() {
        return this.nbOwners;
    }
}

