/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml.tool;

import java.util.ArrayList;
import java.util.List;
import org.neodatis.odb.xml.tool.XMLAttribute;
import org.neodatis.odb.xml.tool.XMLGenerator;

public class XMLNode {
    private String name;
    private List<XMLAttribute> attributes;
    private List<XMLNode> nodes;
    private boolean isRoot;
    private boolean isDone;
    private XMLNode currentChild;
    private int nodeLevel;
    boolean headerHasBeenWritten;
    private XMLGenerator xmlGenerator;

    XMLNode(XMLGenerator xmlGenerator, String name, boolean isRoot) {
        this.name = name;
        this.attributes = new ArrayList<XMLAttribute>();
        this.nodes = new ArrayList<XMLNode>();
        this.isRoot = isRoot;
        this.isDone = false;
        this.nodeLevel = 0;
        this.xmlGenerator = xmlGenerator;
    }

    public XMLNode addAttribute(String name, String value) {
        this.attributes.add(new XMLAttribute(name, value));
        return this;
    }

    public XMLNode createNode(String name) {
        if (this.currentChild != null) {
            boolean canRemoveNode = true;
            if (!this.currentChild.isDone) {
                canRemoveNode = this.currentChild.end();
            }
            if (canRemoveNode) {
                this.currentChild.attributes.clear();
                this.currentChild.nodes.clear();
                this.nodes.remove(this.currentChild);
                this.currentChild = null;
            }
        }
        this.currentChild = new XMLNode(this.xmlGenerator, name, false);
        this.currentChild.nodeLevel = this.nodeLevel + 1;
        this.nodes.add(this.currentChild);
        return this.currentChild;
    }

    public void endHeader() {
        this.xmlGenerator.startOfNode(this.name, this);
        this.headerHasBeenWritten = true;
    }

    public boolean end() {
        this.isDone = true;
        boolean canRemoveNode = this.xmlGenerator.endOfNode(this.name, this);
        if (this.isRoot) {
            this.xmlGenerator.endOfDocument(this.name);
        }
        return canRemoveNode;
    }

    public String headerToString(boolean closeTag) {
        XMLAttribute attribute = null;
        StringBuffer buffer = new StringBuffer(1000);
        String spaces = this.buildSpaces(this.getNodeLevel());
        buffer.append("\n").append(spaces).append("<").append(this.name).append(" ");
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i != 0) {
                buffer.append(" ");
            }
            attribute = this.attributes.get(i);
            buffer.append(attribute.toString());
        }
        if (closeTag) {
            buffer.append("/>");
        } else {
            buffer.append(">");
        }
        return buffer.toString();
    }

    public boolean hasChildren() {
        return !this.nodes.isEmpty();
    }

    public String contentToString() {
        XMLNode node = null;
        StringBuffer buffer = new StringBuffer(5000);
        for (int i = 0; i < this.nodes.size(); ++i) {
            node = this.nodes.get(i);
            buffer.append("\n");
            buffer.append(node.toString());
        }
        return buffer.toString();
    }

    public String footerToString() {
        String spaces = this.buildSpaces(this.getNodeLevel());
        StringBuffer buffer = new StringBuffer(5000);
        buffer.append("\n").append(spaces).append("</").append(this.name).append(">");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(5000);
        buffer.append(this.headerToString(false));
        buffer.append(this.contentToString());
        buffer.append(this.footerToString());
        return buffer.toString();
    }

    String buildSpaces(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNodeLevel() {
        return this.nodeLevel;
    }
}

