/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml.tool;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.xml.tool.NodeEventListener;
import org.neodatis.odb.xml.tool.XMLNode;
import org.neodatis.tool.wrappers.io.OdbFile;

public class XMLGenerator {
    private List<NodeEventListener> listeners = new ArrayList<NodeEventListener>();
    private String incrementalFileName;
    private boolean writeIncremental;
    private Writer incrementalWriter;
    private boolean firstNode = true;
    private String encoding;

    public XMLGenerator(String encoding) {
        this.encoding = encoding;
    }

    public void addListener(NodeEventListener listener) {
        this.listeners.add(listener);
    }

    public void setIncrementalWriteOn(String fileName) throws IOException {
        this.incrementalFileName = fileName;
        this.writeIncremental = true;
        this.incrementalWriter = this.getWriter(fileName);
    }

    public void end() throws IOException {
        if (this.writeIncremental && this.incrementalWriter != null) {
            this.incrementalWriter.close();
        }
    }

    public XMLNode createRoot(String name) {
        XMLNode node = new XMLNode(this, name, true);
        this.startOfDocument(name);
        return node;
    }

    public void startOfDocument(String name) {
        NodeEventListener listener = null;
        if (this.writeIncremental) {
            try {
                this.incrementalWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                this.incrementalWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new NeoDatisRuntimeException((IError)NeoDatisError.XML_HEADER, (Throwable)e);
            }
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = this.listeners.get(i);
            listener.startOfDocument();
        }
    }

    public void endOfDocument(String name) {
        NodeEventListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = this.listeners.get(i);
            listener.endOfDocument();
        }
    }

    public void startOfNode(String name, XMLNode node) {
        NodeEventListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = this.listeners.get(i);
            listener.startOfNode(name, node);
        }
        if (this.writeIncremental) {
            try {
                this.writeIncrementalNodeHeader(node, false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public boolean endOfNode(String name, XMLNode node) {
        NodeEventListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = this.listeners.get(i);
            listener.endOfNode(name, node);
        }
        if (this.writeIncremental) {
            try {
                if (!node.headerHasBeenWritten && !node.hasChildren()) {
                    this.writeIncrementalNodeHeader(node, true);
                    return true;
                }
                this.writeIncrementalNodeFooter(node);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void writeIncrementalNodeHeader(XMLNode node, boolean closeTag) throws IOException {
        this.incrementalWriter.write(node.headerToString(closeTag));
        this.incrementalWriter.flush();
    }

    private void writeIncrementalNodeFooter(XMLNode node) throws IOException {
        this.incrementalWriter.write(node.footerToString());
        this.incrementalWriter.flush();
    }

    public void writeNodeToFile(XMLNode node, String fileName) throws IOException {
        Writer writer = this.getWriter(fileName);
        writer.write(node.toString());
        writer.close();
    }

    private Writer getWriter(String fileName) throws IOException {
        OdbFile f = new OdbFile(fileName);
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        OutputStreamWriter writer = null;
        writer = this.encoding != null ? new OutputStreamWriter((OutputStream)out, this.encoding) : new OutputStreamWriter(out);
        return writer;
    }

    public void close() throws IOException {
        if (this.incrementalWriter != null) {
            this.incrementalWriter.close();
        }
    }
}

