/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.main;

import java.io.File;
import java.util.List;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ExternalOID;
import org.neodatis.odb.ExternalObjectOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODBExt;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.oid.ExternalObjectOIDImpl;
import org.neodatis.odb.core.refactor.RefactorManager;
import org.neodatis.odb.core.server.message.GetFileMessage;
import org.neodatis.odb.core.server.message.GetFileMessageResponse;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.server.message.SendFileMessage;
import org.neodatis.odb.core.server.message.SendFileMessageResponse;
import org.neodatis.odb.core.server.message.process.RemoteProcess;
import org.neodatis.odb.core.server.message.process.RemoteProcessMessage;
import org.neodatis.odb.core.server.message.process.RemoteProcessMessageResponse;
import org.neodatis.odb.core.server.message.process.RemoteProcessReturn;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODBExtImpl
implements ODBExt {
    protected SessionEngine engine;
    protected Session session;

    public ODBExtImpl(SessionEngine sessionEngine) {
        this.engine = sessionEngine;
        this.session = sessionEngine.getSession();
    }

    @Override
    public ExternalOID convertToExternalOID(ObjectOid oid) {
        return this.session.getOidGenerator().toExternalOid(oid, this.session.getDatabaseId());
    }

    @Override
    public TransactionId getCurrentTransactionId() {
        return this.session.getCurrentTransactionId();
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.session.getDatabaseId();
    }

    @Override
    public ExternalObjectOid getObjectExternalOID(Object object) {
        return new ExternalObjectOIDImpl(this.engine.getObjectOid(object, true), this.getDatabaseId());
    }

    @Override
    public long getObjectVersion(ObjectOid oid, boolean useCache) {
        ObjectInfoHeader oih = this.engine.getMetaHeaderFromOid(oid, true, useCache);
        if (oih == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
        }
        return oih.getObjectVersion();
    }

    @Override
    public long getObjectCreationDate(ObjectOid oid) {
        ObjectInfoHeader oih = this.engine.getMetaHeaderFromOid(oid, true, true);
        if (oih == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
        }
        return oih.getCreationDate();
    }

    @Override
    public long getObjectUpdateDate(ObjectOid oid, boolean useCache) {
        ObjectInfoHeader oih = this.engine.getMetaHeaderFromOid(oid, true, useCache);
        if (oih == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
        }
        return oih.getUpdateDate();
    }

    @Override
    public RefactorManager getRefactorManager() {
        return this.engine.getRefactorManager();
    }

    @Override
    public ObjectOid store(ObjectOid oid, Object object) {
        return this.engine.store(oid, object);
    }

    @Override
    public Message sendMessage(Message message) {
        try {
            return this.engine.sendMessage(message);
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public SendFileMessageResponse sendFile(String localFileName, String remoteFileName, boolean putFileInServerInbox) {
        try {
            return (SendFileMessageResponse)this.engine.sendMessage(new SendFileMessage(this.engine.getSession().getBaseIdentification().getBaseId(), this.engine.getSession().getId(), localFileName, remoteFileName, putFileInServerInbox));
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public SendFileMessageResponse sendFile(String localFileName) {
        try {
            String remoteFileName = new File(localFileName).getName();
            return (SendFileMessageResponse)this.engine.sendMessage(new SendFileMessage(this.engine.getSession().getBaseIdentification().getBaseId(), this.engine.getSession().getId(), localFileName, remoteFileName, true));
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public GetFileMessageResponse getFile(String remoteFileName) {
        try {
            return (GetFileMessageResponse)this.engine.sendMessage(new GetFileMessage(this.engine.getSession().getBaseIdentification().getBaseId(), this.engine.getSession().getId(), true, remoteFileName, true, remoteFileName));
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public GetFileMessageResponse getFile(boolean remoteFileInbox, String remoteFileName, boolean localFileInbox, String localFileName) {
        try {
            return (GetFileMessageResponse)this.engine.sendMessage(new GetFileMessage(this.engine.getSession().getBaseIdentification().getBaseId(), this.engine.getSession().getId(), remoteFileInbox, remoteFileName, localFileInbox, localFileName));
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public RemoteProcessReturn executeRemoteProcess(RemoteProcess process, boolean synchronous) {
        try {
            RemoteProcessMessageResponse r = (RemoteProcessMessageResponse)this.engine.sendMessage(new RemoteProcessMessage(this.engine.getSession().getBaseIdentification().getBaseId(), this.engine.getSession().getId(), process, synchronous));
            return r.getRemoteProcessReturn();
        }
        catch (NeoDatisRuntimeException e) {
            e.writeToFile();
            throw e;
        }
    }

    @Override
    public void dontCallTriggersForClasses(List<Class> classes) {
        this.engine.getTriggerManager().addClassesNotToCallTriggersOn(classes);
    }

    @Override
    public ObjectOid objectOidFromString(String id) {
        return this.engine.getSession().getOidGenerator().objectOidFromString(id);
    }

    @Override
    public void disableTriggers() {
        this.engine.getTriggerManager().disableTriggers();
    }

    @Override
    public void enableTriggers() {
        this.engine.getTriggerManager().disableTriggers();
    }
}

