/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.session.cross;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.session.cross.ICrossSessionCache;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class CrossSessionCache
implements ICrossSessionCache {
    private Map<Object, OID> objects = Collections.synchronizedMap(new WeakHashMap());
    private Map<OID, OID> deletedOids = new OdbHashMap<OID, OID>();
    private static Map<String, ICrossSessionCache> instances = new OdbHashMap<String, ICrossSessionCache>();

    protected CrossSessionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICrossSessionCache getInstance(String baseIdentification) {
        ICrossSessionCache cache = instances.get(baseIdentification);
        if (cache == null) {
            Map<String, ICrossSessionCache> map = instances;
            synchronized (map) {
                cache = new CrossSessionCache();
                instances.put(baseIdentification, cache);
            }
        }
        return cache;
    }

    public void addObject(Object o, OID oid) {
        if (o == null) {
            return;
        }
        try {
            this.objects.put(o, oid);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void clear() {
        this.objects.clear();
        this.deletedOids.clear();
    }

    public boolean existObject(Object object) {
        OID oid = this.objects.get(object);
        if (oid == null) {
            return false;
        }
        if (this.deletedOids.containsKey(oid)) {
            this.objects.remove(object);
            this.deletedOids.remove(oid);
            return false;
        }
        return true;
    }

    public boolean slowExistObject(Object object) {
        Iterator<Object> iterator = this.objects.keySet().iterator();
        int i = 1;
        while (iterator.hasNext()) {
            boolean b;
            Object o = iterator.next();
            boolean bl = b = object == o;
            if (b) {
                return b;
            }
            ++i;
        }
        return false;
    }

    public OID getOid(Object object) {
        if (object == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.CACHE_NULL_OBJECT.addParameter(object));
        }
        OID oid = this.objects.get(object);
        if (oid != null) {
            if (this.deletedOids.containsKey(oid)) {
                this.objects.remove(object);
                this.deletedOids.remove(oid);
                return null;
            }
            return oid;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void removeObject(Object object) {
        if (object == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.CACHE_NULL_OBJECT.addParameter(" while removing object from the cache"));
        }
        OID oid = this.objects.remove(object);
        if (oid != null) {
            this.deletedOids.put(oid, oid);
        }
    }

    public void removeOid(OID oid) {
        this.deletedOids.put(oid, oid);
    }

    public int size() {
        return this.objects.size();
    }

    public String toString() {
        StringBuffer b = new StringBuffer(String.format("Cross session cache with %d objects", this.objects.size()));
        Iterator<Object> iterator = this.objects.keySet().iterator();
        int i = 1;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(String.format("\n%d:%s %s hc=%d", i, o.toString(), o.getClass().getSimpleName(), System.identityHashCode(o)));
            ++i;
        }
        return b.toString();
    }

    public static void clearAll() {
        for (String name : instances.keySet()) {
            ICrossSessionCache cache = instances.get(name);
            cache.clear();
        }
        instances.clear();
    }
}

