/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.session;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.session.Cache;

public class Cache2Impl
implements Cache {
    private Map<Integer, ObjectOid> objects;
    protected Map<ObjectOid, Object> oids;

    public Cache2Impl() {
        this.init();
    }

    private void init() {
        this.objects = Collections.synchronizedMap(new WeakHashMap());
        this.oids = Collections.synchronizedMap(new WeakHashMap());
    }

    public boolean existObject(Object object) {
        Integer key = new Integer(System.identityHashCode(object));
        return this.objects.containsKey(key);
    }

    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean throwExceptionIfNotFound) {
        return null;
    }

    public void addObject(ObjectOid oid, Object o) {
        if (o == null) {
            return;
        }
        Integer key = new Integer(System.identityHashCode(o));
        this.objects.put(key, oid);
        this.oids.put(oid, new WeakReference<Object>(o));
    }

    public Object getObjectWithOid(ObjectOid oid) {
        WeakReference wr = (WeakReference)this.oids.get(oid);
        if (wr == null) {
            return null;
        }
        return wr.get();
    }

    public ObjectOid getOid(Object object, boolean throwExceptionIfNotFound) {
        Integer key = new Integer(System.identityHashCode(object));
        return this.objects.get(key);
    }

    public int getSize() {
        return this.objects.size();
    }

    public void clear() {
        this.objects.clear();
        this.oids.clear();
    }

    public void remove(Object o, ObjectOid oid) {
        Integer key = new Integer(System.identityHashCode(o));
        this.objects.remove(key);
        this.oids.remove(oid);
    }

    public void remove(ObjectOid oid) {
        WeakReference ref = (WeakReference)this.oids.remove(oid);
        if (ref != null) {
            Integer key = new Integer(System.identityHashCode(ref.get()));
            this.objects.remove(key);
        }
    }
}

