/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.message.serialization;

import java.util.Map;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesHelper;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.server.message.serialization.AddIndexMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.AddIndexMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.CloseMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.CloseMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.CommitMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.CommitMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.ConnectMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.ConnectMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.CountMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.CountMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.DeleteObjectFromOidMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.DeleteObjectWithOidMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.GetFileMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.GetFileMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.GetObjectFromOidMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.GetObjectFromOidMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.GetObjectsMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.GetObjectsMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.ISerializer;
import org.neodatis.odb.core.server.message.serialization.NextClassInfoOidMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.NextClassInfoOidResponseMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.RemoteProcessMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.RemoteProcessMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.RollbackMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.RollbackMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.SendFileMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.SendFileMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.StoreClassInfoMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.StoreClassInfoMessageSerializer;
import org.neodatis.odb.core.server.message.serialization.StoreObjectMessageResponseSerializer;
import org.neodatis.odb.core.server.message.serialization.StoreObjectMessageSerializer;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class AllSerializers {
    private Map<Integer, ISerializer> serializers = null;
    private NeoDatisConfig config;

    public static synchronized AllSerializers getInstance(NeoDatisConfig config) {
        return new AllSerializers(config);
    }

    private AllSerializers(NeoDatisConfig config) {
        this.config = config;
        this.serializers = new OdbHashMap<Integer, ISerializer>();
        this.serializers.put(new Integer(10), new ConnectMessageSerializer(config));
        this.serializers.put(new Integer(11), new ConnectMessageResponseSerializer(config));
        this.serializers.put(new Integer(40), new StoreObjectMessageSerializer(config));
        this.serializers.put(new Integer(41), new StoreObjectMessageResponseSerializer(config));
        this.serializers.put(new Integer(210), new NextClassInfoOidMessageSerializer(config));
        this.serializers.put(new Integer(211), new NextClassInfoOidResponseMessageSerializer(config));
        this.serializers.put(new Integer(220), new StoreClassInfoMessageSerializer(config));
        this.serializers.put(new Integer(221), new StoreClassInfoMessageResponseSerializer(config));
        this.serializers.put(new Integer(70), new CommitMessageSerializer(config));
        this.serializers.put(new Integer(71), new CommitMessageResponseSerializer(config));
        this.serializers.put(new Integer(80), new RollbackMessageSerializer(config));
        this.serializers.put(new Integer(81), new RollbackMessageResponseSerializer(config));
        this.serializers.put(new Integer(60), new CloseMessageSerializer(config));
        this.serializers.put(new Integer(61), new CloseMessageResponseSerializer(config));
        this.serializers.put(new Integer(20), new GetObjectsMessageSerializer(config));
        this.serializers.put(new Integer(21), new GetObjectsMessageResponseSerializer(config));
        this.serializers.put(new Integer(30), new GetObjectFromOidMessageSerializer(config));
        this.serializers.put(new Integer(31), new GetObjectFromOidMessageResponseSerializer(config));
        this.serializers.put(new Integer(50), new DeleteObjectWithOidMessageSerializer(config));
        this.serializers.put(new Integer(51), new DeleteObjectFromOidMessageResponseSerializer(config));
        this.serializers.put(new Integer(130), new CountMessageSerializer(config));
        this.serializers.put(new Integer(131), new CountMessageResponseSerializer(config));
        this.serializers.put(new Integer(110), new AddIndexMessageSerializer(config));
        this.serializers.put(new Integer(111), new AddIndexMessageResponseSerializer(config));
        this.serializers.put(new Integer(230), new SendFileMessageSerializer(config));
        this.serializers.put(new Integer(231), new SendFileMessageResponseSerializer(config));
        this.serializers.put(new Integer(235), new GetFileMessageSerializer(config));
        this.serializers.put(new Integer(236), new GetFileMessageResponseSerializer(config));
        this.serializers.put(new Integer(240), new RemoteProcessMessageSerializer(config));
        this.serializers.put(new Integer(241), new RemoteProcessMessageResponseSerializer(config));
    }

    public Bytes toBytes(Message message) throws Exception {
        Integer messageType = new Integer(message.getMessageType());
        ISerializer serializer = this.serializers.get(messageType);
        if (serializer != null) {
            return serializer.toBytes(message);
        }
        throw new RuntimeException("toBytes not implemented for message type " + messageType);
    }

    public Message fromBytes(Bytes bytes) throws Exception {
        BytesHelper helper = new BytesHelper(bytes, this.config);
        int messageType = helper.readInt(0);
        ISerializer serializer = this.serializers.get(new Integer(messageType));
        if (serializer != null) {
            return serializer.fromBytes(helper);
        }
        throw new RuntimeException("fromBytes not implemented for message type " + messageType);
    }
}

