/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.odb.core.server.ServerSession;
import org.neodatis.odb.core.server.connection.IConnection;
import org.neodatis.odb.core.server.connection.SessionIdGenerator;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.trigger.TriggerManagerImpl;
import org.neodatis.odb.core.trigger.Triggers;
import org.neodatis.odb.core.trigger.TriggersImpl;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    public static final String LOG_ID = "SessionManager";
    protected BaseIdentification baseIdentification;
    private Map<String, Session> sessions;
    private Triggers triggers;

    public SessionManager(BaseIdentification baseIdentification) {
        this.baseIdentification = baseIdentification;
        this.sessions = new OdbHashMap<String, Session>();
        this.triggers = new TriggersImpl();
    }

    public ServerSession newSession(String ip, long dateTime, int sequence, boolean transactional, NeoDatisConfig neoDatisConfig) {
        String sessionId = SessionIdGenerator.newId(ip, dateTime, sequence);
        BaseIdentification bi = this.baseIdentification.copy();
        bi.setConfig(neoDatisConfig);
        bi.getConfig().setTransactional(transactional);
        ServerSession session = new ServerSession(bi, sessionId);
        session.getEngine().setTriggerManager(new TriggerManagerImpl(session, this.triggers));
        this.sessions.put(sessionId, session);
        return session;
    }

    public Session getSession(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_SERVER_UNKNOWN_SESSION.addParameter(sessionId).addParameter(this.baseIdentification.getBaseId()));
        }
        return session;
    }

    public void removeSession(Session session) {
        this.sessions.remove(session.getId());
    }

    public int getNbSessions() {
        return this.sessions.size();
    }

    public String getSessionDescriptions() {
        Iterator<Session> iterator = this.sessions.values().iterator();
        IConnection connection = null;
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            connection = (IConnection)((Object)iterator.next());
            buffer.append("\n\t+ ").append(connection.getDescription()).append("\n");
        }
        return buffer.toString();
    }

    public synchronized void lockOidForSession(OID oid, Session session, long timeout) throws InterruptedException {
        session.lockOidForSession(oid, timeout);
    }

    public synchronized void lockClassForSession(String fullClassName, Session session, long timeout) throws InterruptedException {
        session.lockClassForSession(fullClassName, timeout);
    }

    public synchronized void unlockOidForSession(OID oid, Session session) throws InterruptedException {
        session.unlockOidForSession(oid);
    }

    public synchronized void unlockClass(String fullClassName, Session session) throws InterruptedException {
        session.unlockClass(fullClassName);
    }

    public Map<String, Session> getSessions() {
        return this.sessions;
    }

    public Triggers getTriggers() {
        return this.triggers;
    }
}

