/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.server.MessageStreamerImpl;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.tool.DLogger;

public class SSLMessageStreamerImpl
extends MessageStreamerImpl {
    public SSLMessageStreamerImpl() {
    }

    public SSLMessageStreamerImpl(Socket socket, NeoDatisConfig config) throws IOException {
        super(socket, config);
    }

    protected Socket createSocket() throws UnknownHostException, IOException {
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        Socket socket = socketFactory.createSocket(this.getHost(), this.getPort());
        return socket;
    }

    public Message read() throws Exception {
        try {
            return super.read();
        }
        catch (SSLHandshakeException e) {
            DLogger.error("NeoDatis: SSL Error : Be sure to set the following ssl properties to start the client java virtual machine : -Djavax.net.ssl.trustStore=<path to truststore> -Djavax.net.ssl.trustStorePassword=<trust store password>");
            throw e;
        }
    }
}

