/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.io.IOException;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.server.ODBServerImpl;
import org.neodatis.odb.core.server.SSLMessageStreamerImpl;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.tool.DLogger;

public class ODBSSLServerImpl
extends ODBServerImpl {
    public ODBSSLServerImpl(int port, NeoDatisConfig config) {
        super(port, config.setSSL(true).setMessageStreamerClass(SSLMessageStreamerImpl.class));
    }

    protected ServerSocket createSocketServer() throws IOException {
        ServerSocketFactory ssocketFactory = SSLServerSocketFactory.getDefault();
        ServerSocket server = ssocketFactory.createServerSocket(this.getPort());
        return server;
    }

    public ClientServerConnection waitForRemoteConnection() throws IOException {
        try {
            return super.waitForRemoteConnection();
        }
        catch (SSLException e) {
            DLogger.error("NeoDatis: SSL Error : Be sure to set the following ssl properties to start the server java virtual machine : -Djavax.net.ssl.keyStore=<path to key store> -Djavax.net.ssl.keyStorePassword=<keystore password>");
            throw e;
        }
    }
}

