/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.odb.core.server.MessageStreamer;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.server.message.serialization.AllSerializers;

public class MessageStreamerImpl
implements MessageStreamer {
    private static final int TIMEOUT = 0;
    private OutputStream out;
    private InputStream in;
    private BufferedOutputStream bos;
    private BufferedInputStream bis;
    private Socket socket;
    private String host;
    private int port;
    private String name;
    private boolean isClosed;
    protected AllSerializers serializer;
    protected ByteArrayConverter converter;
    protected Bytes bytesForDataSize;
    protected ReadSize readSize;
    protected NeoDatisConfig neoDatisConfig;

    public MessageStreamerImpl() {
    }

    public void init(String host, int port, String name, NeoDatisConfig config) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.neoDatisConfig = config;
        this.serializer = AllSerializers.getInstance(this.neoDatisConfig);
        this.converter = new ByteArrayConverterImpl(this.neoDatisConfig.debugLayers(), this.neoDatisConfig.getDatabaseCharacterEncoding(), this.neoDatisConfig);
        this.bytesForDataSize = BytesFactory.getBytes();
        this.readSize = new ReadSize();
        this.initSocket();
    }

    public MessageStreamerImpl(Socket socket, NeoDatisConfig config) throws IOException {
        this.neoDatisConfig = config;
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.socket.setSoTimeout(0);
        this.bos = new BufferedOutputStream(this.out);
        this.bis = new BufferedInputStream(this.in);
        this.serializer = AllSerializers.getInstance(this.neoDatisConfig);
        this.converter = new ByteArrayConverterImpl(this.neoDatisConfig.debugLayers(), this.neoDatisConfig.getDatabaseCharacterEncoding(), this.neoDatisConfig);
        this.bytesForDataSize = BytesFactory.getBytes();
        this.readSize = new ReadSize();
    }

    private void initSocket() {
        if (this.socket == null) {
            try {
                this.socket = this.createSocket();
                this.socket.setTcpNoDelay(true);
                this.out = this.socket.getOutputStream();
                this.socket.setSoTimeout(0);
                this.in = this.socket.getInputStream();
                this.bos = new BufferedOutputStream(this.out);
                this.bis = new BufferedInputStream(this.in);
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
            }
        }
        if (this.isClosed) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.name));
        }
    }

    protected Socket createSocket() throws UnknownHostException, IOException {
        return new Socket(this.host, this.port);
    }

    public void close() {
        try {
            this.bos.flush();
            this.bos.close();
            this.bis.close();
            this.out.close();
            this.in.close();
            this.isClosed = true;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
        }
    }

    public void write(Message message) {
        try {
            Bytes bytes = this.serializer.toBytes(message);
            this.converter.intToByteArray(bytes.getRealSize(), this.bytesForDataSize, 0, "datasize");
            byte[] bb = this.bytesForDataSize.extract(0, 4);
            this.bos.write(bb);
            this.bos.write(bytes.getByteArray());
            this.bos.flush();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.NET_SERIALISATION_ERROR, (Throwable)e);
        }
    }

    public Message read() throws Exception {
        byte[] rbytes;
        byte[] bytes = new byte[1024];
        int size = 0;
        Bytes bb = null;
        byte[] bbb = new byte[4];
        int s = this.bis.read(bbb);
        this.bytesForDataSize.set(0, bbb);
        int dataSize = this.converter.byteArrayToInt(this.bytesForDataSize, 0, this.readSize, "datasize");
        size = this.bis.read(bytes);
        if (size != -1) {
            rbytes = new byte[size];
            System.arraycopy(bytes, 0, rbytes, 0, size);
            bb = BytesFactory.getBytes(rbytes);
        }
        while (this.bis.available() != 0 && size != -1 || bb != null && bb.getRealSize() != dataSize) {
            size = this.bis.read(bytes);
            if (size == -1) continue;
            rbytes = new byte[size];
            System.arraycopy(bytes, 0, rbytes, 0, size);
            bb.append(rbytes);
        }
        if (bb == null) {
            throw new EOFException("Remote socket has been closed");
        }
        if (bb.getRealSize() != dataSize) {
            throw new IOException("Error in transmission, sizes does not match : sent size = " + dataSize + " , received size = " + bb.getRealSize());
        }
        return this.serializer.fromBytes(bb);
    }

    public Message sendAndReceive(Message m) {
        Message rmsg;
        this.write(m);
        try {
            rmsg = this.read();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
        }
        return rmsg;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

