/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.lang.reflect.Field;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.server.ReturnValue;
import org.neodatis.odb.core.server.ReturnValueProcessor;
import org.neodatis.odb.core.server.trigger.ChangedValueNotification;

public class ChangedValueProcessor
implements ReturnValueProcessor {
    protected ClassIntrospector classIntrospector;

    public ChangedValueProcessor(ClassIntrospector classIntrospector) {
        this.classIntrospector = classIntrospector;
    }

    public void process(ReturnValue rv, Object object) throws Exception {
        Field f = null;
        ChangedValueNotification cvn = null;
        try {
            if (rv == null || !(rv instanceof ChangedValueNotification)) {
                return;
            }
            cvn = (ChangedValueNotification)rv;
            Class<?> c = object.getClass();
            f = this.classIntrospector.getField(c, cvn.getAttributeName());
            f.setAccessible(true);
            f.set(object, cvn.getValue());
        }
        catch (IllegalArgumentException e) {
            if (cvn == null || cvn.getValue() == null) {
                throw e;
            }
            throw new NeoDatisRuntimeException(e, "class field type is " + f.getType().getName() + " - new value type = " + cvn.getValue().getClass().getName());
        }
    }
}

