/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.refactor;

import java.io.IOException;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.refactor.RefactorManager;
import org.neodatis.odb.core.session.SessionEngine;

public class RefactorManagerImpl
implements RefactorManager {
    protected SessionEngine engine;

    public RefactorManagerImpl(SessionEngine storageEngine) {
        this.engine = storageEngine;
    }

    public void addField(String className, Class fieldType, String fieldName) {
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        ClassInfo ownerCi = metaModel.getClassInfo(className, true);
        ClassInfo attributeCi = null;
        attributeCi = !ODBType.getFromClass(fieldType).isNative() ? new ClassInfo(fieldType.getName()) : null;
        ClassAttributeInfo cai = new ClassAttributeInfo(-1, fieldName, fieldType.getName(), attributeCi.getOid(), ownerCi.getOid());
        ownerCi.addAttribute(cai);
        this.engine.storeClassInfo(ownerCi);
    }

    public void changeFieldType(String className, String attributeName, Class newType) {
    }

    public void removeClass(String className) {
    }

    public void removeField(String className, String attributeName) throws IOException {
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(className, true);
        ClassAttributeInfo cai2 = ci.getAttributeInfoFromName(attributeName);
        ci.removeAttribute(cai2);
        this.engine.storeClassInfo(ci);
    }

    public void renameClass(String fullClassName, String newFullClassName) throws IOException {
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(fullClassName, true);
        ci.setFullClassName(newFullClassName);
        this.engine.storeClassInfo(ci);
    }

    public void renameField(String className, String attributeName, String newAttributeName) throws IOException {
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        ClassInfo ci = metaModel.getClassInfo(className, true);
        ClassAttributeInfo cai2 = ci.getAttributeInfoFromName(attributeName);
        cai2.setName(newAttributeName);
        this.engine.storeClassInfo(ci);
    }
}

