/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.refactor;

import java.io.Serializable;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoCompareResult
implements Serializable {
    private String fullClassName;
    private ClassInfo oldCI;
    private ClassInfo newCI;
    private IOdbList<String> incompatibleChanges;
    private IOdbList<String> compatibleChanges;

    public ClassInfoCompareResult(String fullClassName, ClassInfo oldCI, ClassInfo newCI) {
        this.fullClassName = fullClassName;
        this.incompatibleChanges = new OdbArrayList<String>(5);
        this.compatibleChanges = new OdbArrayList<String>(5);
        this.oldCI = oldCI;
        this.newCI = newCI;
    }

    public IOdbList<String> getCompatibleChanges() {
        return this.compatibleChanges;
    }

    public void setCompatibleChanges(IOdbList<String> compatibleChanges) {
        this.compatibleChanges = compatibleChanges;
    }

    public IOdbList<String> getIncompatibleChanges() {
        return this.incompatibleChanges;
    }

    public void setIncompatibleChanges(IOdbList<String> incompatibleChanges) {
        this.incompatibleChanges = incompatibleChanges;
    }

    public boolean isCompatible() {
        return this.incompatibleChanges.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fullClassName).append(" is Compatible = ").append(this.isCompatible()).append("\n");
        buffer.append("Incompatible changes = ").append(this.incompatibleChanges);
        buffer.append("\nCompatible changes = ").append(this.compatibleChanges);
        return buffer.toString();
    }

    public void addCompatibleChange(String o) {
        this.compatibleChanges.add(o);
    }

    public void addIncompatibleChange(String o) {
        this.incompatibleChanges.add(o);
    }

    public boolean hasChanged() {
        return this.compatibleChanges.size() > 0 || this.incompatibleChanges.size() > 0;
    }

    public boolean hasCompatibleChanges() {
        return !this.compatibleChanges.isEmpty();
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public ClassInfo getOldCI() {
        return this.oldCI;
    }

    public void setOldCI(ClassInfo oldCI) {
        this.oldCI = oldCI;
    }

    public ClassInfo getNewCI() {
        return this.newCI;
    }

    public void setNewCI(ClassInfo newCI) {
        this.newCI = newCI;
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }
}

