/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.values;

import java.util.Iterator;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.ObjectValues;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilder;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.IQueryFieldAction;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.ValuesQuery;
import org.neodatis.odb.core.query.list.values.DefaultObjectValues;
import org.neodatis.odb.core.query.list.values.InMemoryBTreeCollectionForValues;
import org.neodatis.odb.core.query.list.values.SimpleListForValues;
import org.neodatis.odb.core.query.values.ValuesMatchResult;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.OdbComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesQueryResultAction
implements IMatchingObjectAction {
    private ValuesQuery query;
    private IQueryFieldAction[] queryFieldActions;
    private long nbObjects;
    private Values result;
    private boolean queryHasOrderBy;
    protected InstanceBuilder instanceBuilder;
    protected ClassInfo classInfo;
    private int returnArraySize;
    private SessionEngine engine;

    public ValuesQueryResultAction(ValuesQuery query, SessionEngine storageEngine, InstanceBuilder instanceBuilder) {
        this.engine = storageEngine;
        this.query = query;
        this.queryHasOrderBy = query.hasOrderBy();
        this.instanceBuilder = instanceBuilder;
        this.returnArraySize = query.getObjectActions().size();
        Iterator iterator = query.getObjectActions().iterator();
        IQueryFieldAction qfa = null;
        this.queryFieldActions = new IQueryFieldAction[this.returnArraySize];
        int i = 0;
        while (iterator.hasNext()) {
            qfa = (IQueryFieldAction)iterator.next();
            this.queryFieldActions[i] = qfa.copy();
            this.queryFieldActions[i].setReturnInstance(query.returnInstance());
            this.queryFieldActions[i].setInstanceBuilder(instanceBuilder);
            ++i;
        }
    }

    @Override
    public void add(MatchResult matchResult, Comparable orderByKey) {
        ValuesMatchResult valuesMatchResult = (ValuesMatchResult)matchResult;
        AttributeValuesMap attributeValuesMap = valuesMatchResult.valuesMap;
        if (this.query.isMultiRow()) {
            ObjectValues objectValues = this.convertObject(attributeValuesMap);
            if (this.queryHasOrderBy) {
                this.result.addWithKey(orderByKey, objectValues);
            } else {
                this.result.add(objectValues);
            }
        } else {
            this.compute(attributeValuesMap);
        }
    }

    private void compute(AttributeValuesMap values) {
        for (int i = 0; i < this.returnArraySize; ++i) {
            this.queryFieldActions[i].execute(values.getOid(), values);
        }
    }

    private ObjectValues convertObject(AttributeValuesMap values) {
        DefaultObjectValues dov = new DefaultObjectValues(this.returnArraySize);
        IQueryFieldAction qfa = null;
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.execute(values.getOid(), values);
            Object o = qfa.getValue();
            if (o != null && o instanceof ObjectOid) {
                ObjectOid oid = (ObjectOid)o;
                o = this.engine.getObjectFromOid(oid, true, new InstanceBuilderContext(this.query.getQueryParameters().getLoadDepth()));
            }
            dov.set(i, qfa.getAlias(), o);
        }
        return dov;
    }

    @Override
    public void start() {
        this.result = this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollectionForValues((int)this.nbObjects, this.query.getOrderByType(), this.query.getSessionEngine().getSession().getConfig().getDefaultCollectionBTreeDegree()) : new SimpleListForValues((int)this.nbObjects);
        IQueryFieldAction qfa = null;
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.start();
        }
    }

    @Override
    public void end() {
        IQueryFieldAction qfa = null;
        DefaultObjectValues dov = null;
        if (!this.query.isMultiRow()) {
            dov = new DefaultObjectValues(this.returnArraySize);
        }
        for (int i = 0; i < this.returnArraySize; ++i) {
            qfa = this.queryFieldActions[i];
            qfa.end();
            if (this.query.isMultiRow()) continue;
            Object o = qfa.getValue();
            if (o != null && o instanceof OID) {
                ObjectOid oid = (ObjectOid)o;
                o = this.engine.getObjectFromOid(oid, true, new InstanceBuilderContext(this.query.getQueryParameters().getLoadDepth()));
            }
            dov.set(i, qfa.getAlias(), o);
        }
        if (!this.query.isMultiRow()) {
            this.result.add(dov);
        }
    }

    public Values getValues() {
        return this.result;
    }

    @Override
    public <T> Objects<T> getObjects() {
        return this.result;
    }

    public void addNnoi(OID oid, NonNativeObjectInfo object, OdbComparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    public void addObject(OID oid, Object object, OdbComparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }
}

