/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.values;

import java.util.HashSet;
import java.util.Iterator;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.query.IQueryFieldAction;
import org.neodatis.odb.core.query.ValuesQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.Criterion;
import org.neodatis.odb.core.query.values.AverageValueAction;
import org.neodatis.odb.core.query.values.CountAction;
import org.neodatis.odb.core.query.values.FieldValueAction;
import org.neodatis.odb.core.query.values.ICustomQueryFieldAction;
import org.neodatis.odb.core.query.values.MaxValueAction;
import org.neodatis.odb.core.query.values.MinValueAction;
import org.neodatis.odb.core.query.values.SizeAction;
import org.neodatis.odb.core.query.values.SublistAction;
import org.neodatis.odb.core.query.values.SumAction;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesCriteriaQuery
extends CriteriaQueryImpl
implements ValuesQuery {
    private IOdbList<IQueryFieldAction> objectActions;
    private String[] groupByFieldList;
    private boolean hasGroupBy;
    private boolean returnInstance;

    public ValuesCriteriaQuery(Class aClass, ObjectOid oid) {
        super(aClass.getName());
        this.setOidOfObjectToQuery(oid);
        this.init();
    }

    public ValuesCriteriaQuery(Class aClass, Criterion criteria) {
        super(aClass.getName(), criteria);
        this.init();
    }

    public ValuesCriteriaQuery(Class aClass) {
        super(aClass.getName());
        this.init();
    }

    public ValuesCriteriaQuery(String aFullClassName) {
        super(aFullClassName);
        this.init();
    }

    public ValuesCriteriaQuery(String aFullClassName, Criterion criteria) {
        super(aFullClassName, criteria);
        this.init();
    }

    public ValuesCriteriaQuery(CriteriaQuery query) {
        this(query.getFullClassName(), query.getCriteria());
    }

    private void init() {
        this.objectActions = new OdbArrayList<IQueryFieldAction>();
        this.returnInstance = true;
    }

    @Override
    public ValuesQuery count(String alias) {
        this.objectActions.add(new CountAction(alias));
        return this;
    }

    @Override
    public ValuesQuery sum(String attributeName) {
        return this.sum(attributeName, attributeName);
    }

    @Override
    public ValuesQuery sum(String attributeName, String alias) {
        this.objectActions.add(new SumAction(attributeName, alias));
        return this;
    }

    @Override
    public ValuesQuery sublist(String attributeName, int fromIndex, int size, boolean throwException) {
        return this.sublist(attributeName, attributeName, fromIndex, size, throwException);
    }

    @Override
    public ValuesQuery sublist(String attributeName, String alias, int fromIndex, int size, boolean throwException) {
        this.objectActions.add(new SublistAction(attributeName, alias, fromIndex, size, throwException));
        return this;
    }

    @Override
    public ValuesQuery sublist(String attributeName, int fromIndex, int toIndex) {
        return this.sublist(attributeName, attributeName, fromIndex, toIndex);
    }

    @Override
    public ValuesQuery sublist(String attributeName, String alias, int fromIndex, int toIndex) {
        this.objectActions.add(new SublistAction(attributeName, alias, fromIndex, toIndex));
        return this;
    }

    @Override
    public ValuesQuery size(String attributeName) {
        return this.size(attributeName, attributeName);
    }

    @Override
    public ValuesQuery size(String attributeName, String alias) {
        this.objectActions.add(new SizeAction(attributeName, alias));
        return this;
    }

    @Override
    public ValuesQuery avg(String attributeName) {
        return this.avg(attributeName, attributeName);
    }

    @Override
    public ValuesQuery avg(String attributeName, String alias) {
        this.objectActions.add(new AverageValueAction(attributeName, alias, this.getSessionEngine().getSession().getConfig().getScaleForAverageDivision(), this.getSessionEngine().getSession().getConfig().getRoundTypeForAverageDivision()));
        return this;
    }

    @Override
    public ValuesQuery max(String attributeName) {
        return this.max(attributeName, attributeName);
    }

    @Override
    public ValuesQuery max(String attributeName, String alias) {
        this.objectActions.add(new MaxValueAction(attributeName, alias));
        return this;
    }

    @Override
    public ValuesQuery min(String attributeName) {
        return this.min(attributeName, attributeName);
    }

    @Override
    public ValuesQuery min(String attributeName, String alias) {
        this.objectActions.add(new MinValueAction(attributeName, alias));
        return this;
    }

    @Override
    public ValuesQuery field(String attributeName) {
        return this.field(attributeName, attributeName);
    }

    @Override
    public ValuesQuery field(String attributeName, String alias) {
        this.objectActions.add(new FieldValueAction(attributeName, alias));
        return this;
    }

    @Override
    public ValuesQuery custom(String attributeName, ICustomQueryFieldAction action) {
        return this.custom(attributeName, attributeName, action);
    }

    @Override
    public ValuesQuery custom(String attributeName, String alias, ICustomQueryFieldAction action) {
        action.setAttributeName(attributeName);
        action.setAlias(alias);
        this.objectActions.add(action);
        return this;
    }

    @Override
    public IOdbList<IQueryFieldAction> getObjectActions() {
        return this.objectActions;
    }

    @Override
    public HashSet<String> getAllInvolvedFields() {
        int i;
        HashSet<String> l = new HashSet<String>();
        l.addAll(super.getAllInvolvedFields());
        Iterator iterator = this.objectActions.iterator();
        IQueryFieldAction oa = null;
        String name = null;
        while (iterator.hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            if (oa.getClass() == CountAction.class) continue;
            name = oa.getAttributeName();
            l.add(name);
        }
        if (this.hasGroupBy) {
            for (i = 0; i < this.groupByFieldList.length; ++i) {
                name = this.groupByFieldList[i];
                l.add(name);
            }
        }
        if (this.hasOrderBy()) {
            for (i = 0; i < this.orderByFields.length; ++i) {
                name = this.orderByFields[i];
                l.add(name);
            }
        }
        return l;
    }

    @Override
    public boolean isMultiRow() {
        boolean isMultiRow = true;
        IQueryFieldAction oa = null;
        boolean groupBy = this.hasGroupBy && this.groupByFieldList.length == 1;
        String oneGroupByField = null;
        Iterator iterator = this.objectActions.iterator();
        if (groupBy) {
            oneGroupByField = this.groupByFieldList[0];
            while (iterator.hasNext()) {
                oa = (IQueryFieldAction)iterator.next();
                if (!(oa instanceof FieldValueAction) || !oa.getAttributeName().equals(oneGroupByField)) continue;
                oa.setMultiRow(false);
            }
        }
        if ((iterator = this.objectActions.iterator()).hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            isMultiRow = oa.isMultiRow();
        }
        while (iterator.hasNext()) {
            oa = (IQueryFieldAction)iterator.next();
            if (isMultiRow == oa.isMultiRow()) continue;
            throw new NeoDatisRuntimeException(NeoDatisError.VALUES_QUERY_NOT_CONSISTENT.addParameter(this));
        }
        return isMultiRow;
    }

    @Override
    public ValuesQuery groupBy(String fieldList) {
        this.groupByFieldList = OdbString.split(fieldList, ",");
        this.hasGroupBy = true;
        return this;
    }

    @Override
    public boolean hasGroupBy() {
        return this.hasGroupBy;
    }

    @Override
    public String[] getGroupByFieldList() {
        return this.groupByFieldList;
    }

    @Override
    public boolean returnInstance() {
        return this.returnInstance;
    }

    @Override
    public void setReturnInstance(boolean returnInstance) {
        this.returnInstance = returnInstance;
    }

    @Override
    public Values values() {
        return this.getSessionEngine().getValues(this);
    }
}

