/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.values;

import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.IndexTool;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.ValuesQuery;
import org.neodatis.odb.core.query.list.values.InMemoryBTreeCollectionForValues;
import org.neodatis.odb.core.query.list.values.SimpleListForValues;
import org.neodatis.odb.core.query.values.ValuesMatchResult;
import org.neodatis.odb.core.query.values.ValuesQueryResultAction;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByValuesQueryResultAction
implements IMatchingObjectAction {
    private ValuesQuery query;
    private long nbObjects;
    private Map<Comparable, ValuesQueryResultAction> groupByResult;
    private Values result;
    private boolean queryHasOrderBy;
    protected InstanceBuilder instanceBuilder;
    protected ClassInfo classInfo;
    private int returnArraySize;
    private String[] groupByFieldList;

    public GroupByValuesQueryResultAction(ValuesQuery query, SessionEngine storageEngine, InstanceBuilder instanceBuilder) {
        this.query = query;
        this.queryHasOrderBy = query.hasOrderBy();
        this.instanceBuilder = instanceBuilder;
        this.returnArraySize = query.getObjectActions().size();
        this.groupByFieldList = query.getGroupByFieldList();
        this.groupByResult = new OdbHashMap<Comparable, ValuesQueryResultAction>();
    }

    @Override
    public void add(MatchResult matchResult, Comparable orderByKey) {
        ValuesMatchResult valuesMatchResult = (ValuesMatchResult)matchResult;
        AttributeValuesMap attributeValuesMap = valuesMatchResult.valuesMap;
        Comparable groupByKey = IndexTool.buildIndexKey("GroupBy", attributeValuesMap, this.groupByFieldList);
        ValuesQueryResultAction result = this.groupByResult.get(groupByKey);
        if (result == null) {
            result = new ValuesQueryResultAction(this.query, null, this.instanceBuilder);
            result.start();
            this.groupByResult.put(groupByKey, result);
        }
        result.add(matchResult, orderByKey);
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
        this.result = this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollectionForValues((int)this.nbObjects, this.query.getOrderByType(), this.query.getSessionEngine().getSession().getConfig().getDefaultCollectionBTreeDegree()) : new SimpleListForValues((int)this.nbObjects);
        Iterator<Comparable> iterator = this.groupByResult.keySet().iterator();
        ValuesQueryResultAction vqra = null;
        Comparable key = null;
        while (iterator.hasNext()) {
            key = iterator.next();
            vqra = this.groupByResult.get(key);
            vqra.end();
            this.merge(key, vqra.getValues());
        }
    }

    private void merge(Comparable key, Values values) {
        while (values.hasNext()) {
            if (this.queryHasOrderBy) {
                this.result.addWithKey(key, values.nextValues());
                continue;
            }
            this.result.add(values.nextValues());
        }
    }

    @Override
    public <T> Objects<T> getObjects() {
        return this.result;
    }

    public void addNnoi(OID oid, NonNativeObjectInfo object, Comparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    public void addObject(OID oid, Object object, Comparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }
}

