/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.values;

import java.math.BigDecimal;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.IQueryFieldAction;
import org.neodatis.odb.core.query.values.AbstractQueryFieldAction;
import org.neodatis.odb.core.query.values.ValuesUtil;
import org.neodatis.tool.wrappers.NeoDatisNumber;

public class AverageValueAction
extends AbstractQueryFieldAction {
    private static BigDecimal ONE = new BigDecimal(1);
    private BigDecimal totalValue = new BigDecimal(0);
    private BigDecimal nbValues = new BigDecimal(0);
    private BigDecimal average;
    private int scale;
    private int roundType;

    public AverageValueAction(String attributeName, String alias, int scale, int roundType) {
        super(attributeName, alias, false);
        this.attributeName = attributeName;
        this.scale = scale;
        this.roundType = roundType;
    }

    public void execute(OID oid, AttributeValuesMap values) {
        Number n = (Number)values.get(this.attributeName);
        this.totalValue = NeoDatisNumber.add(this.totalValue, ValuesUtil.convert(n));
        this.nbValues = NeoDatisNumber.add(this.nbValues, ONE);
    }

    public Object getValue() {
        return this.average;
    }

    public void end() {
        this.average = NeoDatisNumber.divide(this.totalValue, this.nbValues, this.roundType, this.scale);
    }

    public void start() {
    }

    public IQueryFieldAction copy() {
        return new AverageValueAction(this.attributeName, this.alias, this.scale, this.roundType);
    }
}

