/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.list.objects;

import java.util.Iterator;
import org.neodatis.OrderByConstants;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.impl.multiplevalue.InMemoryBTreeMultipleValuesPerKey;
import org.neodatis.odb.core.btree.LazyODBBTreeIteratorMultiple;
import org.neodatis.odb.core.query.list.objects.AbstractBTreeCollection;
import org.neodatis.odb.core.session.SessionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBTreeCollection<T>
extends AbstractBTreeCollection<T> {
    private SessionEngine sessionEngine;
    private boolean returnObjects;

    public LazyBTreeCollection(int size, SessionEngine engine, boolean returnObjects, int btreeDegree) {
        super(size, OrderByConstants.ORDER_BY_ASC, btreeDegree);
        this.sessionEngine = engine;
        this.returnObjects = returnObjects;
    }

    public LazyBTreeCollection(int size, OrderByConstants orderByType, int btreeDegree) {
        super(size, orderByType, btreeDegree);
    }

    @Override
    public IBTree buildTree(int degree) {
        return new InMemoryBTreeMultipleValuesPerKey("default", degree);
    }

    @Override
    public Iterator<T> iterator(OrderByConstants orderByType) {
        return new LazyODBBTreeIteratorMultiple(this.getTree(), orderByType, this.sessionEngine, this.returnObjects);
    }
}

