/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.tool.wrappers.OdbString;

public class LikeCriterion
extends AbstractCriterion {
    private String criterionValue;
    private String storedRegExp;
    private boolean isCaseSensitive;

    public LikeCriterion(String attributeName, String criterionValue, boolean isCaseSensitive, boolean escapeRegExpCharacters) {
        super(attributeName);
        this.criterionValue = criterionValue;
        this.isCaseSensitive = isCaseSensitive;
        if (criterionValue == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.LIKE_WITH_NULL_VALUE);
        }
        if (!isCaseSensitive && criterionValue != null) {
            criterionValue = criterionValue.toLowerCase();
        }
        if (escapeRegExpCharacters) {
            criterionValue = this.escapeRegexpCharacters(criterionValue);
        }
        this.storedRegExp = "(?s)\\A(.)*" + criterionValue + "(.)*\\z";
    }

    private String escapeRegexpCharacters(String value) {
        return value.replace("\\", "\\\\").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("*", "\\*").replace("+", "\\+").replace("?", "\\?").replace("$", "\\$").replace("[", "\\[").replace("]", "\\]").replace("^", "\\^");
    }

    public boolean match(Object valueToMatch) {
        Object regExp = null;
        if (valueToMatch == null) {
            return false;
        }
        if (valueToMatch instanceof AttributeValuesMap) {
            AttributeValuesMap attributeValues = (AttributeValuesMap)valueToMatch;
            valueToMatch = attributeValues.get(this.attributeName);
        }
        if (valueToMatch == null) {
            return false;
        }
        if (!(valueToMatch instanceof String)) {
            throw new NeoDatisRuntimeException(NeoDatisError.QUERY_ATTRIBUTE_TYPE_NOT_SUPPORTED_IN_LIKE_EXPRESSION.addParameter(valueToMatch.getClass().getName()));
        }
        String value = (String)valueToMatch;
        if (this.isCaseSensitive) {
            return value != null && OdbString.matches(this.storedRegExp, value);
        }
        return value != null && OdbString.matches(this.storedRegExp, value.toLowerCase());
    }

    public AttributeValuesMap getValues() {
        return new AttributeValuesMap();
    }

    public void ready() {
    }
}

