/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import java.util.HashSet;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.query.GenericQueryExecutor;
import org.neodatis.odb.core.query.IQueryExecutionPlan;
import org.neodatis.odb.core.query.IndexTool;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.SimpleCompareKey;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQueryExecutionPlan;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.CriteriaQueryManager;
import org.neodatis.odb.core.query.criteria.NnoiMatchResult;
import org.neodatis.odb.core.query.criteria.OidMatchResult;
import org.neodatis.odb.core.session.SessionEngine;

public class CriteriaQueryExecutor
extends GenericQueryExecutor {
    private HashSet<String> fields;
    private CriteriaQueryImpl criteriaQuery;
    protected InstanceBuilderContext ibc;

    public CriteriaQueryExecutor(InternalQuery query, SessionEngine engine) {
        super(query, engine);
        this.criteriaQuery = (CriteriaQueryImpl)query;
        this.ibc = new InstanceBuilderContext(query.getQueryParameters().getLoadDepth());
    }

    public IQueryExecutionPlan getExecutionPlan() {
        CriteriaQueryExecutionPlan plan = new CriteriaQueryExecutionPlan(this.classInfo, (CriteriaQueryImpl)this.query);
        return plan;
    }

    public void prepareQuery() {
        this.criteriaQuery = (CriteriaQueryImpl)this.query;
        this.criteriaQuery.setSessionEngine(this.engine);
        this.fields = this.criteriaQuery.getAllInvolvedFields();
        if (this.criteriaQuery.hasOrderBy()) {
            String[] orderByFields = this.criteriaQuery.getOrderByFieldNames();
            for (int i = 0; i < orderByFields.length; ++i) {
                this.fields.add(orderByFields[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchResult matchObjectWithOid(ObjectOid oid, boolean inMemory) {
        block10: {
            block11: {
                SessionEngine engine;
                block7: {
                    block9: {
                        block8: {
                            engine = this.getSessionEngine();
                            Object oih = null;
                            if (this.criteriaQuery.hasCriteria()) break block7;
                            if (!inMemory) break block8;
                            NnoiMatchResult nnoiMatchResult = new NnoiMatchResult(engine.getMetaObjectFromOid(oid, false, this.ibc));
                            return nnoiMatchResult;
                        }
                        if (!engine.existOid(oid)) break block9;
                        OidMatchResult oidMatchResult = new OidMatchResult(oid);
                        return oidMatchResult;
                    }
                    MatchResult matchResult = null;
                    return matchResult;
                }
                boolean optimizeObjectCompararison = this.criteriaQuery.optimizeObjectComparison();
                AttributeValuesMap attributeValues = engine.getFieldValuesFromOid(oid, this.fields, optimizeObjectCompararison, this.query.getQueryParameters().getLoadDepth());
                boolean objectMatches = CriteriaQueryManager.match(this.criteriaQuery, attributeValues);
                if (!objectMatches) break block10;
                if (!inMemory) break block11;
                NnoiMatchResult nnoiMatchResult = new NnoiMatchResult(engine.getMetaObjectFromOid(oid, false, this.ibc));
                return nnoiMatchResult;
            }
            OidMatchResult oidMatchResult = new OidMatchResult(oid);
            return oidMatchResult;
        }
        MatchResult matchResult = null;
        return matchResult;
    }

    public Comparable computeIndexKey(ClassInfo ci, ClassInfoIndex index) {
        CriteriaQuery q = (CriteriaQuery)this.query;
        AttributeValuesMap values = q.getCriteria().getValues();
        if (values.hasOid()) {
            return new SimpleCompareKey(values.getOid());
        }
        return IndexTool.computeKey(this.classInfo, index, (CriteriaQuery)this.query);
    }
}

