/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.OdbReflection;

public class ContainsCriterion
extends AbstractCriterion {
    private Object criterionValue;
    private OID oid;
    private boolean objectIsNative;

    public ContainsCriterion(String attributeName, String criterionValue) {
        super(attributeName);
        this.init(criterionValue);
    }

    public ContainsCriterion(String attributeName, int value) {
        super(attributeName);
        this.init(new Integer(value));
    }

    public ContainsCriterion(String attributeName, short value) {
        super(attributeName);
        this.init(new Short(value));
    }

    public ContainsCriterion(String attributeName, byte value) {
        super(attributeName);
        this.init(new Byte(value));
    }

    public ContainsCriterion(String attributeName, float value) {
        super(attributeName);
        this.init(new Float(value));
    }

    public ContainsCriterion(String attributeName, double value) {
        super(attributeName);
        this.init(new Double(value));
    }

    public ContainsCriterion(String attributeName, long value) {
        super(attributeName);
        this.init(new Long(value));
    }

    protected void init(Object value) {
        this.criterionValue = value;
        this.objectIsNative = this.criterionValue == null ? true : ODBType.isNative(this.criterionValue.getClass());
    }

    public ContainsCriterion(String attributeName, Object value) {
        super(attributeName);
        this.init(value);
    }

    public ContainsCriterion(String attributeName, boolean value) {
        super(attributeName);
        this.init(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean match(Object valueToMatch) {
        if (valueToMatch == null && this.criterionValue == null && this.oid == null) {
            return true;
        }
        if (valueToMatch == null) {
            return false;
        }
        Map m = null;
        if (valueToMatch instanceof Map) {
            m = (Map)valueToMatch;
            if ((valueToMatch = m.get(this.attributeName)) == null && this.criterionValue == null && this.oid == null) {
                return true;
            }
            if (valueToMatch == null) {
                return false;
            }
        }
        if (valueToMatch instanceof Collection) {
            Collection c = (Collection)valueToMatch;
            return this.checkIfCollectionContainsValue(c);
        }
        Class<?> clazz = valueToMatch.getClass();
        if (clazz.isArray()) {
            return this.checkIfArrayContainsValue(valueToMatch);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_CONTAINS_CRITERION_TYPE_NOT_SUPPORTED.addParameter(valueToMatch.getClass().getName()));
    }

    private boolean checkIfCollectionContainsValue(Collection c) {
        SessionEngine engine = this.getQuery().getSessionEngine();
        if (engine == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.QUERY_ENGINE_NOT_SET);
        }
        AbstractObjectInfo aoi = null;
        Iterator iterator = c.iterator();
        if (this.objectIsNative) {
            while (iterator.hasNext()) {
                aoi = (AbstractObjectInfo)iterator.next();
                if (aoi == null && this.criterionValue == null) {
                    return true;
                }
                if (aoi != null && this.criterionValue == null) {
                    return false;
                }
                if (!this.criterionValue.equals(aoi.getObject())) continue;
                return true;
            }
            return false;
        }
        while (iterator.hasNext()) {
            NonNativeObjectInfo nnoi1;
            boolean isEqual;
            aoi = (AbstractObjectInfo)iterator.next();
            if (aoi.isNull() && this.criterionValue == null && this.oid == null) {
                return true;
            }
            if (!(aoi != null & this.oid != null) || !aoi.isNonNativeObject() || !(isEqual = (nnoi1 = (NonNativeObjectInfo)aoi).getOid() != null && this.oid != null && nnoi1.getOid().equals(this.oid))) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfArrayContainsValue(Object valueToMatch) {
        int arrayLength = OdbReflection.getArrayLength(valueToMatch);
        Object element = null;
        AbstractObjectInfo aoi = null;
        for (int i = 0; i < arrayLength; ++i) {
            element = OdbReflection.getArrayElement(valueToMatch, i);
            if (element == null && this.criterionValue == null) {
                return true;
            }
            aoi = (AbstractObjectInfo)element;
            if (aoi == null || aoi.getObject() == null || !aoi.getObject().equals(this.criterionValue)) continue;
            return true;
        }
        return false;
    }

    public AttributeValuesMap getValues() {
        return new AttributeValuesMap();
    }

    public void ready() {
        if (!this.objectIsNative) {
            if (this.getQuery() == null) {
                throw new NeoDatisRuntimeException(NeoDatisError.CONTAINS_QUERY_WITH_NO_QUERY);
            }
            SessionEngine engine = this.getQuery().getSessionEngine();
            if (engine == null) {
                throw new NeoDatisRuntimeException(NeoDatisError.CONTAINS_QUERY_WITH_NO_STORAGE_ENGINE);
            }
            this.oid = engine.getObjectOid(this.criterionValue, false);
            this.criterionValue = null;
        }
    }
}

