/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.criteria.NnoiMatchResult;
import org.neodatis.odb.core.query.criteria.OidMatchResult;
import org.neodatis.odb.core.query.list.objects.InMemoryBTreeCollection;
import org.neodatis.odb.core.query.list.objects.LazyBTreeCollection;
import org.neodatis.odb.core.query.list.objects.LazySimpleListFromOid;
import org.neodatis.odb.core.query.list.objects.SimpleList;
import org.neodatis.odb.core.query.nq.NQMatchResult;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.OdbComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionQueryResultAction
implements IMatchingObjectAction {
    private InternalQuery query;
    private boolean inMemory;
    private long nbObjects;
    private SessionEngine sessionEngine;
    private boolean returnObjects;
    private Objects<Object> result;
    private boolean queryHasOrderBy;
    protected InstanceBuilderContext ibc;

    public CollectionQueryResultAction(InternalQuery query, SessionEngine sessionEngine, boolean returnObjects) {
        this.query = query;
        this.inMemory = query.getQueryParameters().isInMemory();
        this.sessionEngine = sessionEngine;
        this.returnObjects = returnObjects;
        this.queryHasOrderBy = query.hasOrderBy();
        this.ibc = new InstanceBuilderContext(query.getQueryParameters().getLoadDepth());
    }

    @Override
    public void add(MatchResult matchResult, Comparable orderByKey) {
        if (matchResult instanceof NnoiMatchResult) {
            NnoiMatchResult nnoiMatchResult = (NnoiMatchResult)matchResult;
            if (this.inMemory) {
                if (this.returnObjects) {
                    if (this.queryHasOrderBy) {
                        this.result.addWithKey(orderByKey, this.getInstance(nnoiMatchResult.nnoi));
                    } else {
                        this.result.add(this.getInstance(nnoiMatchResult.nnoi));
                    }
                } else if (this.queryHasOrderBy) {
                    this.result.addWithKey(orderByKey, (Object)nnoiMatchResult.nnoi);
                } else {
                    this.result.add(nnoiMatchResult.nnoi);
                }
            }
        } else if (matchResult instanceof OidMatchResult) {
            OidMatchResult oidMatchResult = (OidMatchResult)matchResult;
            if (this.queryHasOrderBy) {
                this.result.addWithKey(orderByKey, (Object)oidMatchResult.oid);
            } else {
                this.result.add(oidMatchResult.oid);
            }
        } else if (matchResult instanceof NQMatchResult) {
            NQMatchResult nqMatchResult = (NQMatchResult)matchResult;
            if (this.queryHasOrderBy) {
                this.result.addWithKey(orderByKey, nqMatchResult.object);
            } else {
                this.result.add(nqMatchResult.object);
            }
        }
    }

    @Override
    public void start() {
        this.result = this.inMemory ? (this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollection<Object>((int)this.nbObjects, this.query.getOrderByType(), this.query.getSessionEngine().getSession().getConfig().getDefaultCollectionBTreeDegree()) : new SimpleList<Object>((int)this.nbObjects)) : (this.query != null && this.query.hasOrderBy() ? new LazyBTreeCollection<Object>((int)this.nbObjects, this.sessionEngine, this.returnObjects, this.query.getSessionEngine().getSession().getConfig().getDefaultCollectionBTreeDegree()) : new LazySimpleListFromOid<Object>((int)this.nbObjects, this.sessionEngine, this.returnObjects, this.query.getQueryParameters().getLoadDepth()));
    }

    @Override
    public void end() {
    }

    public Object getInstance(NonNativeObjectInfo nnoi) {
        if (nnoi.getObject() != null) {
            return nnoi.getObject();
        }
        return this.sessionEngine.layer2ToLayer1(nnoi, this.ibc);
    }

    @Override
    public <T> Objects<T> getObjects() {
        return this.result;
    }

    public void addObject(OID oid, Object object, OdbComparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    public void addValues(OID oid, AttributeValuesMap map, OdbComparable orderByKey) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }
}

