/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.IMultiClassQueryExecutor;
import org.neodatis.odb.core.query.IQueryExecutor;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.wrappers.list.IOdbList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassGenericQueryExecutor
implements IQueryExecutor {
    private static final String LOG_ID = "MultiClassGenericQueryExecutor";
    private IMultiClassQueryExecutor executor;

    public MultiClassGenericQueryExecutor(IMultiClassQueryExecutor executor) {
        this.executor = executor;
        this.executor.setExecuteStartAndEndOfQueryAction(false);
    }

    @Override
    public <T> Objects<T> execute(IMatchingObjectAction queryResultAction) {
        Session session = this.executor.getSessionEngine().getSession();
        if (session.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.executor.getSessionEngine().getSession().getBaseIdentification()));
        }
        if (session.isRollbacked()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        String fullClassName = QueryManager.getFullClassName(this.executor.getQuery());
        queryResultAction.start();
        IOdbList<ClassInfo> allClassInfos = session.getMetaModel().getPersistentSubclassesOf(fullClassName);
        int nbClasses = allClassInfos.size();
        ClassInfo ci = null;
        for (int i = 0; i < nbClasses; ++i) {
            ci = allClassInfos.get(i);
            this.executor.setClassInfo(ci);
            this.executor.execute(queryResultAction);
        }
        queryResultAction.end();
        return queryResultAction.getObjects();
    }

    public boolean executeStartAndEndOfQueryAction() {
        return false;
    }
}

