/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.query.ComposedCompareKey;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;

public class IndexTool {
    public static Comparable buildIndexKey(String indexName, NonNativeObjectInfo oi, int[] fieldIds) {
        Comparable[] keys = new Comparable[fieldIds.length];
        AbstractObjectInfo aoi = null;
        Comparable o = null;
        for (int i = 0; i < fieldIds.length; ++i) {
            try {
                aoi = oi.getAttributeValueFromId(fieldIds[i]);
                o = (Comparable)aoi.getObject();
                if (aoi.getOdbType().isBoolean()) {
                    Boolean b = (Boolean)o;
                    o = b != false ? new Byte(1) : new Byte(0);
                }
                if (aoi.isNonNativeObject()) {
                    NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aoi;
                    o = nnoi.getOid();
                }
                keys[i] = o;
                continue;
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INDEX_KEYS_MUST_IMPLEMENT_COMPARABLE.addParameter(fieldIds[i]).addParameter(oi.getAttributeValueFromId(fieldIds[i]).getClass().getName()));
            }
        }
        if (keys.length == 1) {
            return keys[0];
        }
        return new ComposedCompareKey(keys);
    }

    public static Comparable buildIndexKey(String indexName, AttributeValuesMap values, String[] fields) {
        if (fields.length == 1) {
            return values.getComparable(fields[0]);
        }
        Comparable[] keys = new Comparable[fields.length];
        Comparable object = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                object = (Comparable)values.get(fields[i]);
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    object = b != false ? new Byte(1) : new Byte(0);
                }
                keys[i] = object;
                continue;
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INDEX_KEYS_MUST_IMPLEMENT_COMPARABLE.addParameter(indexName).addParameter(fields[i]).addParameter(values.get(fields[i]).getClass().getName()));
            }
        }
        ComposedCompareKey key = new ComposedCompareKey(keys);
        return key;
    }

    public static Comparable computeKey(ClassInfo ci, ClassInfoIndex index, CriteriaQuery query) {
        String[] attributesNames = ci.getAttributeNames(index.getAttributeIds());
        AttributeValuesMap values = query.getCriteria().getValues();
        return IndexTool.buildIndexKey(index.getName(), values, attributesNames);
    }
}

