/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import java.util.ArrayList;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeMultipleValuesPerKey;
import org.neodatis.btree.IBTreeSingleValuePerKey;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.btree.LazyODBBTreePersister;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.query.EmptyExecutionPlan;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.IMultiClassQueryExecutor;
import org.neodatis.odb.core.query.IQueryExecutionPlan;
import org.neodatis.odb.core.query.IQueryExecutorCallback;
import org.neodatis.odb.core.query.IndexTool;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.query.criteria.NnoiMatchResult;
import org.neodatis.odb.core.query.criteria.OidMatchResult;
import org.neodatis.odb.core.query.nq.NQMatchResult;
import org.neodatis.odb.core.query.values.ValuesMatchResult;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.tool.MemoryMonitor;
import org.neodatis.tool.DLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericQueryExecutor<T>
implements IMultiClassQueryExecutor {
    public static final String LOG_ID = "GenericQueryExecutor";
    protected SessionEngine engine;
    protected InternalQuery query;
    protected ClassInfo classInfo;
    protected Session session;
    private boolean queryHasOrderBy;
    private Comparable orderByKey;
    protected IQueryExecutorCallback callback;
    protected boolean executeStartAndEndOfQueryAction;

    public GenericQueryExecutor(InternalQuery query, SessionEngine engine) {
        this.query = query;
        this.engine = engine;
        this.session = engine.getSession();
        this.callback = this.session.getConfig().getQueryExecutorCallback();
        this.executeStartAndEndOfQueryAction = true;
    }

    public abstract IQueryExecutionPlan getExecutionPlan();

    public abstract void prepareQuery();

    public abstract Comparable computeIndexKey(ClassInfo var1, ClassInfoIndex var2);

    public abstract MatchResult matchObjectWithOid(ObjectOid var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> execute(IMatchingObjectAction queryResultAction) {
        if (this.session.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.session.getBaseIdentification()));
        }
        if (this.session.isRollbacked()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        if (this.classInfo == null) {
            String fullClassName = QueryManager.getFullClassName(this.query);
            if (!this.session.getMetaModel().existClass(fullClassName)) {
                queryResultAction.start();
                queryResultAction.end();
                this.query.setExecutionPlan(new EmptyExecutionPlan());
                return queryResultAction.getObjects();
            }
            this.classInfo = this.session.getMetaModel().getClassInfo(fullClassName, true);
        }
        IQueryExecutionPlan plan = this.getExecutionPlan();
        plan.start();
        try {
            if (plan.useIndex() && this.session.getConfig().useIndex()) {
                Objects<T> objects = this.executeUsingIndex(plan.getIndex(), queryResultAction);
                return objects;
            }
            if (this.query.isForSingleOid()) {
                Objects<T> objects = this.executeForOneOid(queryResultAction);
                return objects;
            }
            Objects<T> objects = this.executeFullScan(queryResultAction);
            return objects;
        }
        finally {
            plan.end();
        }
    }

    private <T> Objects<T> executeFullScan(IMatchingObjectAction queryResultAction) {
        boolean objectInRange = false;
        if (this.session.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.session.getBaseIdentification()));
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        int startIndex = this.query.getQueryParameters().getStartIndex();
        int endIndex = this.query.getQueryParameters().getEndIndex();
        boolean inMemory = this.query.getQueryParameters().isInMemory();
        ObjectOid oid = null;
        ObjectOidIterator oidIterator = this.engine.getObjectOidIterator(this.classInfo.getOid(), ObjectOidIterator.Way.INCREASING);
        this.prepareQuery();
        if (this.query != null) {
            this.queryHasOrderBy = this.query.hasOrderBy();
        }
        boolean monitorMemory = this.session.getConfig().monitoringMemory();
        int nbObjectsInResult = 0;
        int i = 0;
        MatchResult matchResult = null;
        while (oidIterator.hasNext()) {
            if (monitorMemory && i % 10000 == 0) {
                MemoryMonitor.displayCurrentMemory("" + (i + 1), true);
            }
            this.orderByKey = null;
            oid = oidIterator.next();
            if (oid == null) continue;
            if (endIndex != -1 && nbObjectsInResult >= endIndex) break;
            objectInRange = startIndex == -1 || nbObjectsInResult >= startIndex;
            if (!inMemory && this.query == null) {
                ++nbObjectsInResult;
                if (objectInRange) {
                    this.orderByKey = null;
                    if (this.query.hasOrderBy()) {
                        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_SUPPORTED);
                    }
                    boolean exist = this.engine.existOid(oid);
                    if (exist) {
                        queryResultAction.add(new OidMatchResult(oid), this.orderByKey);
                    }
                }
            } else {
                matchResult = this.matchObjectWithOid(oid, inMemory);
                if (matchResult != null && matchResult.match) {
                    ++nbObjectsInResult;
                    if (objectInRange) {
                        if (this.queryHasOrderBy) {
                            this.orderByKey = this.buildOrderByKey(matchResult);
                        }
                        queryResultAction.add(matchResult, this.orderByKey);
                        if (this.callback != null) {
                            this.callback.readingObject(i, -1L);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.end();
        }
        return queryResultAction.getObjects();
    }

    private <T> Objects<T> executeUsingIndex(ClassInfoIndex index, IMatchingObjectAction queryResultAction) {
        if (index.getBTree().getPersister() == null) {
            index.getBTree().setPersister(new LazyODBBTreePersister(this.engine));
        }
        long btreeSize = index.getBTree().getSize();
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        this.prepareQuery();
        if (this.query != null) {
            this.queryHasOrderBy = this.query.hasOrderBy();
        }
        IBTree tree = index.getBTree();
        boolean isUnique = index.isUnique();
        Comparable key = this.computeIndexKey(this.classInfo, index);
        ArrayList<ObjectOid> list = null;
        if (isUnique) {
            IBTreeSingleValuePerKey treeSingle = (IBTreeSingleValuePerKey)tree;
            ObjectOid o = (ObjectOid)treeSingle.search(key);
            if (o != null) {
                list = new ArrayList<ObjectOid>();
                list.add(o);
            }
        } else {
            IBTreeMultipleValuesPerKey treeMultiple = (IBTreeMultipleValuesPerKey)tree;
            list = treeMultiple.search(key);
        }
        if (list != null) {
            MatchResult result = null;
            for (ObjectOid oid : list) {
                this.orderByKey = null;
                result = this.matchObjectWithOid(oid, this.query.getQueryParameters().isInMemory());
                if (!result.match) continue;
                queryResultAction.add(result, this.orderByKey);
            }
            queryResultAction.end();
            return queryResultAction.getObjects();
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.end();
        }
        return queryResultAction.getObjects();
    }

    private <T> Objects<T> executeForOneOid(IMatchingObjectAction queryResultAction) {
        if (this.session.getConfig().isDebugEnabled(LOG_ID)) {
            DLogger.debug("loading Object with oid " + this.query.getOidOfObjectToQuery() + " - class " + this.classInfo.getFullClassName());
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        this.prepareQuery();
        ObjectOid oid = this.query.getOidOfObjectToQuery();
        MatchResult result = this.matchObjectWithOid(oid, this.query.getQueryParameters().isInMemory());
        queryResultAction.add(result, this.orderByKey);
        queryResultAction.end();
        return queryResultAction.getObjects();
    }

    public Comparable buildOrderByKey(MatchResult matchResult) {
        if (matchResult instanceof ValuesMatchResult) {
            ValuesMatchResult r = (ValuesMatchResult)matchResult;
            return this.buildOrderByKey(r.valuesMap);
        }
        if (matchResult instanceof NnoiMatchResult) {
            NnoiMatchResult r = (NnoiMatchResult)matchResult;
            return this.buildOrderByKey(r.nnoi);
        }
        if (matchResult instanceof NQMatchResult) {
            NQMatchResult r = (NQMatchResult)matchResult;
            return this.buildOrderByKey(r.nnoi);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_SUPPORTED);
    }

    public Comparable buildOrderByKey(NonNativeObjectInfo nnoi) {
        return IndexTool.buildIndexKey("OrderBy", nnoi, QueryManager.getOrderByAttributeIds(this.classInfo, this.query));
    }

    public Comparable buildOrderByKey(AttributeValuesMap values) {
        return IndexTool.buildIndexKey("OrderBy", values, this.query.getOrderByFieldNames());
    }

    @Override
    public boolean executeStartAndEndOfQueryAction() {
        return this.executeStartAndEndOfQueryAction;
    }

    @Override
    public void setExecuteStartAndEndOfQueryAction(boolean yes) {
        this.executeStartAndEndOfQueryAction = yes;
    }

    @Override
    public InternalQuery getQuery() {
        return this.query;
    }

    @Override
    public void setClassInfo(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    @Override
    public SessionEngine getSessionEngine() {
        return this.engine;
    }
}

