/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.sequential;

import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ExternalOID;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.basics.NLong;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.oid.ExternalOIDImpl;
import org.neodatis.odb.core.oid.OidGeneratorAdapter;
import org.neodatis.odb.core.oid.StringOid;
import org.neodatis.odb.core.oid.sequential.ClassOidImpl;
import org.neodatis.odb.core.oid.sequential.ObjectOidImpl;
import org.neodatis.odb.core.oid.sequential.StringOidImpl;

public class SequentialOidGeneratorImpl
extends OidGeneratorAdapter {
    protected static final ClassOid NULL_CLASS_OID = new ClassOidImpl(0L);
    protected static final ObjectOid NULL_OBJECT_OID = new ObjectOidImpl(NULL_CLASS_OID, 0L);
    protected static final String PREFIX_CURRENT_OBJECT_ID = "CURRENT-OID";
    protected static ByteArrayConverter converter = new ByteArrayConverterImpl(false, null, NeoDatis.getConfig());
    protected Map<OID, NLong> nextOids = new HashMap<OID, NLong>();
    protected Map<Long, ClassOid> coids = new HashMap<Long, ClassOid>();
    protected Map<ClassOid, StringOid> stringClassOid = new HashMap<ClassOid, StringOid>();

    public synchronized ClassOid createClassOid() {
        return this.getNextClassOid();
    }

    public synchronized ObjectOid createObjectOid(ClassOid classOid) {
        return this.getNextObjectOid(classOid);
    }

    public ClassOid buildClassOID(byte[] bb) {
        if (bb.length == 0) {
            return NULL_CLASS_OID;
        }
        long lcoid = converter.byteArrayToLong(bb, 0, "coid");
        ClassOid coid = this.coids.get(lcoid);
        if (coid != null) {
            return coid;
        }
        coid = new ClassOidImpl(lcoid);
        this.coids.put(lcoid, coid);
        return coid;
    }

    public ObjectOid buildObjectOID(byte[] bb) {
        if (bb.length == 0) {
            return NULL_OBJECT_OID;
        }
        long loid = converter.byteArrayToLong(bb, 0, "oid");
        long lcoid = converter.byteArrayToLong(bb, 8, "coid");
        ClassOid coid = this.coids.get(lcoid);
        if (coid == null) {
            coid = new ClassOidImpl(lcoid);
            this.coids.put(lcoid, coid);
        }
        return new ObjectOidImpl(coid, loid);
    }

    public OID buildStringOid(String s) {
        return null;
    }

    public ExternalOID toExternalOid(ObjectOid oid, DatabaseId databaseId) {
        return new ExternalOIDImpl(oid, databaseId);
    }

    public synchronized ClassOid getNextClassOid() {
        StringOidImpl soid = new StringOidImpl("class-oid");
        long l = this.readLong(soid, true);
        if (l == Long.MIN_VALUE) {
            l = 1L;
            this.writeLong(soid, l);
        } else {
            this.writeLong(soid, ++l);
        }
        return new ClassOidImpl(l);
    }

    public synchronized ObjectOid getNextObjectOid(ClassOid classOid) {
        StringOid oid = this.stringClassOid.get(classOid);
        if (oid == null) {
            oid = new StringOidImpl(PREFIX_CURRENT_OBJECT_ID + classOid.oidToString());
            this.stringClassOid.put(classOid, oid);
        }
        NLong l = null;
        if (this.useCache) {
            l = this.nextOids.get(oid);
        }
        if (l == null) {
            long l1 = this.readLong(oid, true);
            if (l1 != Long.MIN_VALUE) {
                l = new NLong(l1);
            }
            if (l == null) {
                l = new NLong(1L);
            } else {
                l.add(1);
            }
        } else {
            l.add(1);
        }
        if (this.useCache) {
            this.nextOids.put(oid, l);
        } else {
            this.writeLong(oid, l.get());
        }
        ObjectOidImpl ooid = new ObjectOidImpl(classOid, l.get());
        return ooid;
    }

    public ClassOid getNullClassOid() {
        return NULL_CLASS_OID;
    }

    public ObjectOid getNullObjectOid() {
        return NULL_OBJECT_OID;
    }

    public void commit() {
        if (this.useCache) {
            for (OID oid : this.nextOids.keySet()) {
                this.writeLong(oid, this.nextOids.get(oid).get());
            }
        }
    }

    public static ObjectOid oidFromString(String s) {
        String[] tokens = s.split("\\.");
        if (tokens.length != 3) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        int type = Integer.parseInt(tokens[0]);
        if (type != 4) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        long classId = Long.parseLong(tokens[1]);
        long objectId = Long.parseLong(tokens[2]);
        return new ObjectOidImpl(new ClassOidImpl(classId), objectId);
    }

    public ObjectOid objectOidFromString(String s) {
        return ObjectOidImpl.oidFromString(s);
    }

    public ClassOid classOidFromString(String s) {
        return this.classOidFromString(s);
    }
}

