/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4.plugin.memory;

import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.StorageEngineAdapter;
import org.neodatis.odb.core.layers.layer4.plugin.memory.InMemoryClassOidIterator;
import org.neodatis.odb.core.layers.layer4.plugin.memory.InMemoryObjectOidIterator;
import org.neodatis.odb.core.oid.StringOid;
import org.neodatis.odb.core.oid.StringOidImpl;
import org.neodatis.tool.DLogger;

public class InMemoryStorageEngine
extends StorageEngineAdapter {
    public String CLASS_OID = "class-oid";
    public String STRING_OID = "string-oid";
    protected boolean debug = false;
    protected Map<String, Map<OID, OidAndBytes>> stores;

    public OidAndBytes read(OID oid, boolean useCache) {
        if (this.debug) {
            DLogger.info("Reading OID " + oid.oidToString());
        }
        if (oid == null) {
            return null;
        }
        if (oid instanceof ObjectOid) {
            ObjectOid ooid = (ObjectOid)oid;
            ClassOid coid = ooid.getClassOid();
            Map<OID, OidAndBytes> store = this.stores.get(coid.oidToString());
            if (store == null) {
                return null;
            }
            return store.get(oid);
        }
        if (oid instanceof ClassOid) {
            ClassOid coid = (ClassOid)oid;
            Map<OID, OidAndBytes> store = this.stores.get(this.CLASS_OID);
            if (store == null) {
                return null;
            }
            return store.get(oid);
        }
        if (oid instanceof StringOid) {
            Map<OID, OidAndBytes> store = this.stores.get(this.STRING_OID);
            if (store == null) {
                return null;
            }
            return store.get(oid);
        }
        throw new RuntimeException("get:Unmanaged OID of type " + oid.getClass().getName());
    }

    public void write(OidAndBytes oidAndBytes) {
        OID oid;
        if (this.debug) {
            DLogger.info("Writing OID " + oidAndBytes.oid.oidToString() + " | bytes = " + oidAndBytes.bytes);
        }
        if ((oid = oidAndBytes.oid) instanceof ObjectOid) {
            ObjectOid ooid = (ObjectOid)oid;
            ClassOid coid = ooid.getClassOid();
            Map<OID, OidAndBytes> store = this.stores.get(coid.oidToString());
            if (store == null) {
                store = new HashMap<OID, OidAndBytes>();
                this.stores.put(coid.oidToString(), store);
            }
            store.put(oid, oidAndBytes);
            return;
        }
        if (oid instanceof ClassOid) {
            ClassOid coid = (ClassOid)oid;
            Map<OID, OidAndBytes> store = this.stores.get(this.CLASS_OID);
            store.put(oid, oidAndBytes);
            return;
        }
        if (oid instanceof StringOid) {
            Map<OID, OidAndBytes> store = this.stores.get(this.STRING_OID);
            store.put(oid, oidAndBytes);
            return;
        }
        throw new RuntimeException("get:Unmanaged OID of type " + oid.getClass().getName());
    }

    public void close() {
    }

    public void commit() {
    }

    public void open(String baseName, NeoDatisConfig config) {
        this.stores = new HashMap<String, Map<OID, OidAndBytes>>();
        this.stores.put(this.CLASS_OID, new HashMap());
        this.stores.put(this.STRING_OID, new HashMap());
    }

    public void open(String host, int port, String baseName, NeoDatisConfig config) {
        throw new RuntimeException("Client server mode is not supported by InMemory Mode");
    }

    public void rollback() {
        throw new RuntimeException("rollback not supported by InMemory Mode");
    }

    public void deleteObjectWithOid(OID oid) {
        if (oid instanceof ObjectOid) {
            ObjectOid ooid = (ObjectOid)oid;
            ClassOid coid = ooid.getClassOid();
            Map<OID, OidAndBytes> store = this.stores.get(coid.oidToString());
            if (store == null) {
                return;
            }
            store.remove(oid);
            return;
        }
        if (oid instanceof ClassOid) {
            ClassOid coid = (ClassOid)oid;
            Map<OID, OidAndBytes> store = this.stores.get(this.CLASS_OID);
            if (store == null) {
                return;
            }
            store.remove(oid);
            return;
        }
        if (oid instanceof StringOidImpl) {
            Map<OID, OidAndBytes> store = this.stores.get(this.STRING_OID);
            if (store == null) {
                return;
            }
            store.remove(oid);
            return;
        }
        throw new RuntimeException("get:Unmanaged OID of type " + oid.getClass().getName());
    }

    public boolean existOid(OID oid) {
        if (oid == null) {
            return false;
        }
        if (oid instanceof ObjectOid) {
            ObjectOid ooid = (ObjectOid)oid;
            ClassOid coid = ooid.getClassOid();
            Map<OID, OidAndBytes> store = this.stores.get(coid.oidToString());
            if (store == null) {
                return false;
            }
            return store.containsKey(oid);
        }
        if (oid instanceof ClassOid) {
            ClassOid coid = (ClassOid)oid;
            Map<OID, OidAndBytes> store = this.stores.get(this.CLASS_OID);
            if (store == null) {
                return false;
            }
            return store.containsKey(oid);
        }
        if (oid instanceof StringOidImpl) {
            Map<OID, OidAndBytes> store = this.stores.get(this.STRING_OID);
            if (store == null) {
                return false;
            }
            return store.containsKey(oid);
        }
        throw new RuntimeException("get:Unmanaged OID of type " + oid.getClass().getName());
    }

    public String getEngineDirectoryForBaseName(String theBaseName) {
        return null;
    }

    public String getStorageEngineName() {
        return "in memory";
    }

    public boolean useDirectory() {
        return false;
    }

    public ClassOidIterator getClassOidIterator() {
        return new InMemoryClassOidIterator(this.stores.get(this.CLASS_OID));
    }

    public ObjectOidIterator getObjectOidIterator(ClassOid classOid, ObjectOidIterator.Way way) {
        Map<OID, OidAndBytes> store = this.stores.get(classOid.oidToString());
        return new InMemoryObjectOidIterator(store);
    }
}

