/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4.plugin.jdbm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.RecordManagerOptions;
import jdbm.btree.BTree;
import jdbm.helper.FastIterator;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer4.kv.KVStore;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.BytesSerializer;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.KeySerializer;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.OidComparator;
import org.neodatis.odb.core.oid.StringOid;
import org.neodatis.tool.DLogger;

public class PHashMapBTree
implements KVStore {
    public String CLASS_OID = "class-oid";
    public String STRING_OID = "string-oid";
    public String STRING = "string";
    protected RecordManager recordManager;
    protected boolean debug = false;
    protected Map<String, BTree> btrees;

    public PHashMapBTree(String fileName, boolean withTransaction, boolean withCache) throws IOException {
        RecordManagerOptions.FILE_EXTENSION = "";
        Properties props = new Properties();
        if (!withTransaction) {
            props.setProperty("jdbm.disableTransactions", "TRUE");
            props.setProperty("jdbm.disableTransactions.syncOnClose", "TRUE");
        }
        if (!withCache) {
            props.setProperty("none", "TRUE");
            props.setProperty("jdbm.cache.type", "none");
        } else {
            props.setProperty("none", "FALSE");
        }
        File f = new File(fileName);
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        if (f.exists() && f.isDirectory()) {
            throw new NeoDatisRuntimeException(fileName + " is a directory, it must be a file");
        }
        this.recordManager = RecordManagerFactory.createRecordManager(fileName, props);
        this.btrees = new HashMap<String, BTree>();
    }

    public void put(OID key, Object value) {
        if (key instanceof ObjectOid) {
            ObjectOid oid = (ObjectOid)key;
            BTree btree = this.getBtreeForName(oid.getClassOid().oidToString());
            if (this.debug) {
                DLogger.info("inserting object data of oid " + key.oidToString() + " in store " + oid.getClassOid().oidToString());
            }
            try {
                btree.insert(oid, (Serializable)value, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (key instanceof StringOid) {
            StringOid oid = (StringOid)key;
            BTree btree = this.getBtreeForName(this.STRING_OID);
            if (this.debug) {
                DLogger.info("inserting object data of oid " + key.oidToString() + " in store " + this.STRING_OID);
            }
            try {
                btree.insert(oid, (Serializable)value, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (key instanceof ClassOid) {
            BTree btree = this.getBtreeForName(this.CLASS_OID);
            if (this.debug) {
                DLogger.info("inserting class info data of oid " + key.oidToString() + " in store " + this.CLASS_OID);
            }
            try {
                btree.insert(key, (Serializable)value, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        throw new RuntimeException("put:Unmanaged OID of type " + key.getClass().getName());
    }

    public Object get(OID key) {
        if (key instanceof ObjectOid) {
            ObjectOid oid = (ObjectOid)key;
            BTree btree = this.getBtreeForName(oid.getClassOid().oidToString());
            if (this.debug) {
                DLogger.info("reading object data of oid " + key.oidToString() + " in store " + oid.getClassOid().oidToString());
            }
            try {
                return btree.find(oid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (key instanceof StringOid) {
            StringOid oid = (StringOid)key;
            BTree btree = this.getBtreeForName(this.STRING_OID);
            if (this.debug) {
                DLogger.info("reading object data of oid " + key.oidToString() + " in store " + this.STRING_OID);
            }
            try {
                return btree.find(oid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (key instanceof ClassOid) {
            BTree btree = this.getBtreeForName(this.CLASS_OID);
            if (this.debug) {
                DLogger.info("reading class info data of oid " + key.oidToString() + " in store " + this.CLASS_OID);
            }
            try {
                return btree.find(key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("get:Unmanaged OID of type " + key.getClass().getName());
    }

    public Object remove(OID key) {
        if (key instanceof ObjectOid) {
            ObjectOid oid = (ObjectOid)key;
            BTree btree = this.getBtreeForName(oid.getClassOid().oidToString());
            try {
                return btree.remove(oid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (key instanceof ClassOid) {
            BTree btree = this.getBtreeForName(this.CLASS_OID);
            try {
                return btree.remove(key.oidToString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public boolean containsKey(OID key) {
        return this.get(key) != null;
    }

    public BTree getBtreeForName(String soid) {
        try {
            BTree btree = this.btrees.get(soid);
            if (btree != null) {
                return btree;
            }
            long recid = this.recordManager.getNamedObject(soid);
            if (recid != 0L) {
                btree = BTree.load(this.recordManager, recid);
                this.btrees.put(soid, btree);
            } else {
                btree = BTree.createInstance(this.recordManager, new OidComparator(), new KeySerializer(), new BytesSerializer());
                this.recordManager.setNamedObject(soid, btree.getRecid());
                this.btrees.put(soid, btree);
            }
            return btree;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }

    public void commit() throws IOException {
        this.recordManager.commit();
    }

    public void rollback() throws IOException {
        this.recordManager.rollback();
    }

    public FastIterator keys() throws IOException {
        return null;
    }

    public void close() throws IOException {
        this.recordManager.close();
    }

    public BTree getClassOidBTree() {
        return this.getBtreeForName(this.CLASS_OID);
    }
}

