/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4.plugin.jdbm;

import java.io.IOException;
import java.util.Iterator;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.OidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmClassOidIterator
implements ClassOidIterator {
    protected BTree btree;
    protected TupleBrowser browser;
    protected Tuple<byte[], Object> tuple;
    protected OidGenerator oidGenerator;

    public JdbmClassOidIterator(BTree btree, OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
        this.btree = btree;
        try {
            this.browser = this.btree.browse();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
        this.tuple = new Tuple();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.browser.getNext(this.tuple);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }

    @Override
    public ClassOid next() {
        return this.oidGenerator.buildClassOID(this.tuple.getKey());
    }

    @Override
    public void reset() {
        try {
            this.browser = this.btree.browse();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e);
        }
        this.tuple = null;
    }

    @Override
    public Iterator<ClassOid> iterator() {
        return (Iterator)((Object)this);
    }
}

