/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4;

import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.layers.layer4.StorageEngine;

public abstract class StorageEngineAdapter
implements StorageEngine {
    protected OidGenerator oidGenerator;
    protected ByteArrayConverter converter;
    protected NeoDatisConfig config;
    protected boolean useCacheForOid;

    public OidGenerator buildOidGenerator() {
        OidGenerator generator = this.config.getCoreProvider().getOidGenerator();
        this.useCacheForOid = this.config.oidGeneratorUseCache();
        generator.init(this, this.useCacheForOid);
        return generator;
    }

    public void init(NeoDatisConfig config) {
        this.config = config;
        this.converter = config.getCoreProvider().getByteArrayConverter(config.debugLayers(), config.getDatabaseCharacterEncoding(), config);
        this.oidGenerator = this.buildOidGenerator();
    }

    public abstract OidAndBytes read(OID var1, boolean var2);

    public abstract void write(OidAndBytes var1);

    public abstract ObjectOidIterator getObjectOidIterator(ClassOid var1, ObjectOidIterator.Way var2);

    public abstract ClassOidIterator getClassOidIterator();

    public OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    public long readLong(OID oid, boolean useCache) {
        OidAndBytes oidAndBytes = this.read(oid, useCache);
        if (oidAndBytes == null) {
            return Long.MIN_VALUE;
        }
        return this.converter.byteArrayToLong(oidAndBytes.bytes, 0, new ReadSize(), "long");
    }

    public void writeLong(OID oid, long l) {
        Bytes bytes = BytesFactory.getBytes();
        this.converter.longToByteArray(l, bytes, 0, "long");
        OidAndBytes oidAndBytes = new OidAndBytes(oid, bytes);
        this.write(oidAndBytes);
    }
}

