/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4;

import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.tool.wrappers.net.NeoDatisIpAddress;

public class IOSocketParameter
implements BaseIdentification {
    private String destinationHost;
    private int port;
    private String baseIdentifier;
    private String user;
    private transient String password;
    protected boolean clientAndServerRunInSameVM;
    protected NeoDatisConfig config;

    public IOSocketParameter(String identifier, NeoDatisConfig config) {
        this.config = config;
        this.destinationHost = config.getHost();
        if (this.destinationHost.indexOf(".") == -1) {
            this.destinationHost = NeoDatisIpAddress.get(this.destinationHost);
        }
        this.port = config.getPort();
        this.baseIdentifier = identifier;
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseIdentifier() {
        return this.baseIdentifier;
    }

    public boolean canWrite() {
        return true;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.user;
    }

    public void setUserName(String user) {
        this.user = user;
    }

    public String toString() {
        return this.baseIdentifier;
    }

    public String getBaseId() {
        return this.toString();
    }

    public boolean isNew() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean clientAndServerRunInSameVM() {
        return this.clientAndServerRunInSameVM;
    }

    public String getDirectory() {
        return "";
    }

    public String getFullIdentification() {
        return this.getBaseId();
    }

    public NeoDatisConfig getConfig() {
        return this.config;
    }

    public BaseIdentification copy() {
        IOSocketParameter p = new IOSocketParameter(this.baseIdentifier, this.config.copy());
        p.clientAndServerRunInSameVM = this.clientAndServerRunInSameVM;
        return p;
    }

    public void setConfig(NeoDatisConfig neoDatisConfig) {
        this.config = neoDatisConfig;
    }
}

