/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionContext {
    public Map<OID, NonNativeObjectInfo> alreadyConvertedOids = new HashMap<OID, NonNativeObjectInfo>();
    protected IOdbList<OidAndBytes> oidAndBytes;
    public Map<OID, OidAndBytes> oabByObjectId;
    public Map<OID, OID> oidsToReplace;
    public ObjectOid lastOid;
    public int recursionLevel;
    public boolean isMainObject;
    public OidAndBytes mainOab;
    public int depth;

    public ConversionContext() {
        this.oidAndBytes = new OdbArrayList<OidAndBytes>();
        this.recursionLevel = 0;
        this.isMainObject = true;
        this.depth = 0;
    }

    public boolean isMainObject() {
        return this.isMainObject;
    }

    public void setIsMainObject(boolean isMainObject) {
        this.isMainObject = isMainObject;
    }

    public ConversionContext(IOdbList<OidAndBytes> oabs, Map<OID, OID> oidsToReplace) {
        this.oidAndBytes = oabs;
        this.oidsToReplace = oidsToReplace;
        this.oabByObjectId = new HashMap<OID, OidAndBytes>();
        for (OidAndBytes oab : oabs) {
            this.oabByObjectId.put(oab.oid, oab);
        }
    }

    public OidAndBytes getOabWithOid(OID oid) {
        if (this.oabByObjectId == null) {
            return null;
        }
        return this.oabByObjectId.get(oid);
    }

    public void addOidAndBytes(OID oid, Bytes bytes, NonNativeObjectInfo objectInfo, boolean isMain) {
        OidAndBytes oab = new OidAndBytes(oid, bytes, objectInfo);
        if (!isMain) {
            this.oidAndBytes.add(oab);
        } else {
            this.mainOab = oab;
        }
    }

    protected void order() {
        this.oidAndBytes.add(0, this.mainOab);
        this.mainOab = null;
    }

    public IOdbList<OidAndBytes> getOidAndBytes() {
        if (this.mainOab != null) {
            this.order();
        }
        return this.oidAndBytes;
    }

    public void setLastOid(ObjectOid existingOid) {
        this.lastOid = existingOid;
    }

    public ObjectOid getLastOid() {
        return this.lastOid;
    }

    public OID replaceOid(OID oid) {
        if (this.oidsToReplace == null) {
            return oid;
        }
        OID newOid = this.oidsToReplace.get(oid);
        if (newOid == null) {
            return oid;
        }
        return newOid;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }
}

