/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import org.neodatis.odb.core.layers.layer3.Bytes;

public class BytesImpl2
implements Bytes {
    protected int size;
    protected byte[] bytes;
    protected long offset;
    protected int maxPosition;
    protected static final int MAX_SIZE_FOR_MANUEL_LOOP = 5;

    public BytesImpl2() {
        this.size = 256;
        this.bytes = new byte[this.size];
        this.maxPosition = -1;
    }

    public BytesImpl2(byte[] byteArray) {
        this.size = byteArray.length;
        this.bytes = new byte[this.size];
        this.copy(byteArray, 0, 0, this.size, false);
    }

    public int append(Bytes bytes) {
        return this.append(bytes.getByteArray());
    }

    public int append(byte[] b) {
        int l = b.length;
        this.checkIndex(this.maxPosition + l);
        System.arraycopy(b, 0, this.bytes, this.maxPosition + 1, l);
        this.maxPosition += l;
        return b.length;
    }

    public void copy(byte[] bytesToCopy, int from, int to, int length, boolean check) {
        if (check) {
            this.checkIndex(to + length);
        }
        System.arraycopy(bytesToCopy, from, this.bytes, to, length);
        int newMaxPosition = to + length - 1;
        if (this.maxPosition < newMaxPosition) {
            this.maxPosition = newMaxPosition;
        }
    }

    public byte[] extract(int offset, int length) {
        byte[] b = new byte[length];
        if (this.size < 5) {
            for (int i = 0; i < this.size; ++i) {
                b[i] = this.bytes[offset + i];
            }
        } else {
            System.arraycopy(this.bytes, offset, b, 0, length);
        }
        return b;
    }

    public byte[] extract(byte[] bytesWhereToWrite, int offsetWhereToWrite, int offsetWhereToRead, int length) {
        System.arraycopy(bytesWhereToWrite, offsetWhereToRead, bytesWhereToWrite, offsetWhereToWrite, length);
        return bytesWhereToWrite;
    }

    public byte get(int index) {
        return this.bytes[index];
    }

    public byte[] get(int index, byte[] dest, int destOffset, int size) {
        if (size < 5) {
            for (int i = 0; i < size; ++i) {
                dest[destOffset + i] = this.bytes[index + i];
            }
        } else {
            System.arraycopy(this.bytes, index, dest, destOffset, size);
        }
        return dest;
    }

    public byte[] getByteArray() {
        byte[] b = new byte[this.maxPosition + 1];
        System.arraycopy(this.bytes, 0, b, 0, this.maxPosition + 1);
        return b;
    }

    public byte[] getByteArray(int index) {
        return null;
    }

    public int getNbBlocks() {
        return 1;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRealSize() {
        return this.maxPosition + 1;
    }

    public boolean hasOffset() {
        return false;
    }

    public void set(int index, byte b) {
        this.checkIndex(index);
        this.bytes[index] = b;
        if (this.maxPosition < index) {
            this.maxPosition = index;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size) {
            int newSize = this.size * 3 / 2 + 1;
            if (newSize < index) {
                newSize = index + 1;
            }
            byte[] bytes2 = new byte[newSize];
            System.arraycopy(this.bytes, 0, bytes2, 0, this.size);
            this.size = newSize;
            this.bytes = bytes2;
        }
    }

    public void set(int index, byte[] bb) {
        int l = bb.length;
        this.checkIndex(index + l);
        if (bb.length < 5) {
            for (int i = 0; i < bb.length; ++i) {
                this.bytes[index + i] = bb[i];
            }
        } else {
            System.arraycopy(bb, 0, this.bytes, index, l);
        }
        int newMaxPosition = index + l - 1;
        if (this.maxPosition < newMaxPosition) {
            this.maxPosition = newMaxPosition;
        }
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

