/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.tool.DLogger;

public class ByteArrayConverterImpl
implements ByteArrayConverter {
    private String encoding;
    private boolean hasEncoding;
    private static final byte BYTE_FOR_TRUE = 1;
    private static final byte BYTE_FOR_FALSE = 0;
    private static int INT_SIZE = 0;
    private static int INT_SIZE_x_2 = 0;
    private static int LONG_SIZE = 0;
    private static boolean debug;
    protected byte[] intBytes;
    protected byte[] longBytes;
    protected OidGenerator oidGenerator;

    public ByteArrayConverterImpl(boolean debug, String characterEncoding, NeoDatisConfig config) {
        this.init(debug, characterEncoding, config);
    }

    public void init(boolean debug, String characterEncoding, NeoDatisConfig config) {
        INT_SIZE = ODBType.INTEGER.getSize();
        INT_SIZE_x_2 = INT_SIZE * 2;
        LONG_SIZE = ODBType.LONG.getSize();
        this.setDatabaseCharacterEncoding(characterEncoding);
        ByteArrayConverterImpl.debug = debug;
        this.intBytes = new byte[INT_SIZE];
        this.longBytes = new byte[LONG_SIZE];
        this.oidGenerator = config.getCoreProvider().getOidGenerator();
    }

    public int booleanToByteArray(boolean b, Bytes arrayWhereToWrite, int offset, String label) {
        if (b) {
            arrayWhereToWrite.set(offset, (byte)1);
        } else {
            arrayWhereToWrite.set(offset, (byte)0);
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : boolean '%b' : %s", (long)offset + arrayWhereToWrite.getOffset(), b, label));
        }
        return 1;
    }

    public boolean byteArrayToBoolean(Bytes bytes, int offset, ReadSize readSize, String label) {
        boolean b = false;
        if (bytes.get(offset) == 0) {
            bytes = null;
            b = false;
        } else {
            b = true;
        }
        readSize.add(1);
        if (debug) {
            DLogger.debug(String.format("     reading at %d : bool '%b' : %s", offset, b, label));
        }
        return b;
    }

    public byte byteArrayToByte(Bytes bytes, int offset, ReadSize readSize, String label) {
        readSize.add(1);
        byte b = bytes.get(offset);
        if (debug) {
            DLogger.debug(String.format("     reading at %d : byte '%d' : %s", offset, b, label));
        }
        return b;
    }

    public int shortToByteArray(short s, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 8;
        while (i < 2) {
            arrayWhereToWrite.set(i + offset, (byte)(0xFF & s >> shift));
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing short %d at %d : %s", s, (long)offset + arrayWhereToWrite.getOffset(), label));
        }
        return 2;
    }

    public short byteArrayToShort(Bytes bytes, int offset, ReadSize readSize, String label) {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | bytes.get(i + offset) & 0xFF);
        }
        readSize.add(2);
        if (debug) {
            DLogger.debug(String.format("     reading short %d at %d : %s", result, offset, label));
        }
        return result;
    }

    public int charToByteArray(char c, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 8;
        while (i < 2) {
            arrayWhereToWrite.set(i + offset, (byte)(0xFF & c >> shift));
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : char '%c' : %s", (long)offset + arrayWhereToWrite.getOffset(), Character.valueOf(c), label));
        }
        return 2;
    }

    public char byteArrayToChar(Bytes bytes, int offset, ReadSize readSize, String label) {
        char result = '\u0000';
        for (int i = 0; i < 2; ++i) {
            result = (char)(result << 8);
            result = (char)(result | bytes.get(i + offset) & 0xFF);
        }
        readSize.add(2);
        if (debug) {
            DLogger.debug(String.format("     reading at %d : char %c : %s", offset, Character.valueOf(result), label));
        }
        return result;
    }

    public int getNumberOfBytesOfAString(String s, boolean useEncoding) {
        if (useEncoding && this.hasEncoding) {
            try {
                return s.getBytes(this.encoding).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new NeoDatisRuntimeException(NeoDatisError.UNSUPPORTED_ENCODING.addParameter(this.encoding));
            }
        }
        return s.getBytes().length;
    }

    public int stringToByteArray(String s, boolean withEncoding, Bytes bytesWhereToWrite, int offset, String label) {
        byte[] bytes = null;
        if (withEncoding && this.hasEncoding) {
            try {
                bytes = s.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new NeoDatisRuntimeException(e, e.getMessage());
            }
        } else {
            bytes = s.getBytes();
        }
        int totalSize = bytes.length;
        this.intToByteArray(totalSize, bytesWhereToWrite, offset, label);
        bytesWhereToWrite.copy(bytes, 0, offset + INT_SIZE, bytes.length, true);
        if (debug) {
            DLogger.debug(String.format("    writing at %d : string '%s' : %s", (long)offset + bytesWhereToWrite.getOffset(), s, label));
        }
        return totalSize + INT_SIZE;
    }

    public String byteArrayToString(Bytes bytes, boolean useEncoding, int offset, ReadSize readSize, String label) {
        String s = null;
        int realSize = this.byteArrayToInt(bytes, offset, readSize, label);
        byte[] rbytes = bytes.extract(offset + INT_SIZE, realSize);
        if (useEncoding && this.hasEncoding) {
            try {
                s = new String(rbytes, 0, realSize, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new NeoDatisRuntimeException(e, e.getMessage());
            }
        } else {
            s = new String(rbytes, 0, realSize);
        }
        readSize.add(realSize);
        bytes = null;
        if (debug) {
            DLogger.debug(String.format("     reading at %d : string '%s' : %s", offset, s, label));
        }
        return s;
    }

    public int bigDecimalToByteArray(BigDecimal bigDecimal, Bytes bytesWhereToWrite, int offset, String label) {
        return this.stringToByteArray(bigDecimal.toString(), false, bytesWhereToWrite, offset, label);
    }

    public BigDecimal byteArrayToBigDecimal(Bytes bytes, int offset, ReadSize readSize, String label) {
        String s = this.byteArrayToString(bytes, false, offset, readSize, label);
        return new BigDecimal(s);
    }

    public int bigIntegerToByteArray(BigInteger bigInteger, Bytes bytesWhereToWrite, int offset, String label) {
        return this.stringToByteArray(bigInteger.toString(), false, bytesWhereToWrite, offset, label);
    }

    public BigInteger byteArrayToBigInteger(Bytes bytes, int offset, ReadSize readSize, String label) {
        String s = this.byteArrayToString(bytes, false, offset, readSize, label);
        return new BigInteger(s);
    }

    public int intToByteArray2(int l, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 24;
        while (i < 4) {
            arrayWhereToWrite.set(offset + i, (byte)(0xFF & l >> shift));
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : int '%d' : %s", offset, l, label));
        }
        return INT_SIZE;
    }

    public int intToByteArray(int l, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 24;
        while (i < 4) {
            this.intBytes[i] = (byte)(0xFF & l >> shift);
            ++i;
            shift -= 8;
        }
        arrayWhereToWrite.set(offset, this.intBytes);
        if (debug) {
            DLogger.debug(String.format("    writing at %d : int '%d' : %s", (long)offset + arrayWhereToWrite.getOffset(), l, label));
        }
        return INT_SIZE;
    }

    public int intToByteArray(int l, byte[] arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 24;
        while (i < 4) {
            arrayWhereToWrite[offset + i] = (byte)(0xFF & l >> shift);
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : int '%d' : %s", offset, l, label));
        }
        return INT_SIZE;
    }

    public int byteToByteArray(byte b, Bytes arrayWhereToWrite, int offset, String label) {
        arrayWhereToWrite.set(offset, b);
        if (debug) {
            DLogger.debug(String.format("    writing at %d : byte '%d' : %s", (long)offset + arrayWhereToWrite.getOffset(), b, label));
        }
        return 1;
    }

    public int byteArrayToInt(Bytes bytes, int offset, ReadSize readSize, String label) {
        int result = 0;
        this.intBytes = bytes.get(offset, this.intBytes, 0, 4);
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= this.intBytes[i] & 0xFF;
        }
        readSize.add(4);
        bytes = null;
        if (debug) {
            DLogger.debug(String.format("     reading at %d : int '%d' : %s", offset, result, label));
        }
        return result;
    }

    public int byteArrayToInt(byte[] bytes, int offset, String label) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= bytes[offset + i] & 0xFF;
        }
        if (debug) {
            DLogger.debug(String.format("     reading at %d : int '%d' : %s", offset, result, label));
        }
        return result;
    }

    public int byteArrayToInt2(Bytes bytes, int offset, ReadSize readSize, String label) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= bytes.get(i + offset) & 0xFF;
        }
        readSize.add(4);
        bytes = null;
        if (debug) {
            DLogger.debug(String.format("     reading at %d : int '%d' : %s", offset, result, label));
        }
        return result;
    }

    public int longToByteArray2(long l, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            arrayWhereToWrite.set(offset + i, (byte)(0xFFL & l >> shift));
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : long '%d' : %s", offset, l, label));
        }
        return LONG_SIZE;
    }

    public int longToByteArray(long l, Bytes arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            this.longBytes[i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
        arrayWhereToWrite.set(offset, this.longBytes);
        if (debug) {
            DLogger.debug(String.format("    writing at %d : long '%d' : %s", (long)offset + arrayWhereToWrite.getOffset(), l, label));
        }
        return LONG_SIZE;
    }

    public int longToByteArray(long l, byte[] arrayWhereToWrite, int offset, String label) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            arrayWhereToWrite[i + offset] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : long '%d' : %s", offset, l, label));
        }
        return LONG_SIZE;
    }

    public long byteArrayToLong(Bytes bytes, int offset, ReadSize readSize, String label) {
        long result = 0L;
        this.longBytes = bytes.get(offset, this.longBytes, 0, 8);
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(this.longBytes[i] & 0xFF);
        }
        readSize.add(8);
        bytes = null;
        if (debug) {
            DLogger.debug(String.format("     reading at %d : long %d : %s", offset, result, label));
        }
        return result;
    }

    public long byteArrayToLong(byte[] bytes, int offset, String label) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[offset + i] & 0xFF);
        }
        if (debug) {
            DLogger.debug(String.format("     reading at %d : long %d : %s", offset, result, label));
        }
        return result;
    }

    public long byteArrayToLong2(Bytes bytes, int offset, ReadSize readSize, String label) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes.get(i + offset) & 0xFF);
        }
        readSize.add(8);
        bytes = null;
        if (debug) {
            DLogger.debug(String.format("     reading at %d : long %d : %s", offset, result, label));
        }
        return result;
    }

    public int dateToByteArray(Date date, Bytes arrayWhereToWrite, int offset, String label) {
        return this.longToByteArray(date.getTime(), arrayWhereToWrite, offset, label);
    }

    public Date byteArrayToDate(Bytes bytes, int offset, ReadSize readSize, String label) {
        return new Date(this.byteArrayToLong(bytes, offset, readSize, label));
    }

    public int floatToByteArray(float f, Bytes arrayWhereToWrite, int offset, String label) {
        int i = Float.floatToIntBits(f);
        return this.intToByteArray(i, arrayWhereToWrite, offset, label);
    }

    public float byteArrayToFloat(Bytes bytes, int offset, ReadSize readSize, String label) {
        return Float.intBitsToFloat(this.byteArrayToInt(bytes, offset, readSize, label));
    }

    public int doubleToByteArray(double d, Bytes arrayWhereToWrite, int offset, String label) {
        long i = Double.doubleToLongBits(d);
        return this.longToByteArray(i, arrayWhereToWrite, offset, label);
    }

    public double byteArrayToDouble(Bytes bytes, int offset, ReadSize readSize, String label) {
        return Double.longBitsToDouble(this.byteArrayToLong(bytes, offset, readSize, label));
    }

    public void setDatabaseCharacterEncoding(String databaseCharacterEncoding) {
        this.encoding = databaseCharacterEncoding;
        this.hasEncoding = this.encoding != null;
    }

    public void testEncoding(String encoding) throws UnsupportedEncodingException {
        "test encoding".getBytes(encoding);
    }

    public ObjectOid byteArrayToObjectOid(Bytes bytes, int offset, ReadSize readSize, String label) {
        int size = this.byteArrayToInt(bytes, offset, readSize, "oid bytes size");
        byte[] bb = bytes.extract(offset + INT_SIZE, size);
        ObjectOid oid = this.oidGenerator.buildObjectOID(bb);
        readSize.add(size);
        if (debug) {
            DLogger.debug(String.format("     reading at %d : object oid '%s' ", offset, oid, label));
        }
        return oid;
    }

    public ClassOid byteArrayToClassOid(Bytes bytes, int offset, ReadSize readSize, String label) {
        int size = this.byteArrayToInt(bytes, offset, readSize, "oid bytes size");
        byte[] bb = bytes.extract(offset + INT_SIZE, size);
        ClassOid oid = this.oidGenerator.buildClassOID(bb);
        readSize.add(size);
        if (debug) {
            DLogger.debug(String.format("     reading at %d : class oid '%s' ", offset, oid, label));
        }
        return oid;
    }

    public int oidToByteArray(OID ooid, Bytes arrayWhereToWrite, int offset, String label) {
        if (ooid == null || ooid.isNull()) {
            if (debug) {
                DLogger.debug(String.format("    writing at %d : null object oid : %s", (long)offset + arrayWhereToWrite.getOffset(), label));
            }
            return this.intToByteArray(0, arrayWhereToWrite, offset, "null oid");
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : object oid '%s' : %s", (long)offset + arrayWhereToWrite.getOffset(), ooid.toString(), label));
        }
        byte[] bb = ooid.toByte();
        this.intToByteArray(bb.length, arrayWhereToWrite, offset, "oid bytes size");
        arrayWhereToWrite.set(offset + INT_SIZE, bb);
        return bb.length + INT_SIZE;
    }

    public int objectOidToByteArray(ObjectOid ooid, Bytes arrayWhereToWrite, int offset, String label) {
        if (ooid == null) {
            ooid = this.oidGenerator.getNullObjectOid();
        }
        return this.oidToByteArray(ooid, arrayWhereToWrite, offset, label);
    }

    public int classOidToByteArray(ClassOid coid, Bytes arrayWhereToWrite, int offset, String label) {
        if (coid == null) {
            coid = this.oidGenerator.getNullClassOid();
        }
        return this.oidToByteArray(coid, arrayWhereToWrite, offset, label);
    }
}

