/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.ObjectRepresentation;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.DefaultInstrumentationCallback;
import org.neodatis.odb.core.layers.layer1.ObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.server.trigger.ChangedValueNotification;

public class ObjectRepresentationImpl
extends Observable
implements ObjectRepresentation {
    private final NonNativeObjectInfo nnoi;
    private final ObjectIntrospector introspector;
    private Map<String, Object> changedValues;

    public ObjectRepresentationImpl(NonNativeObjectInfo nnoi, ObjectIntrospector objectIntrospector) {
        this.nnoi = nnoi;
        this.introspector = objectIntrospector;
        this.changedValues = new HashMap<String, Object>();
    }

    public Object getValueOf(String attributeName) {
        if (this.nnoi.isNull()) {
            throw new NeoDatisRuntimeException(NeoDatisError.TRIGGER_CALLED_ON_NULL_OBJECT.addParameter(this.nnoi.getClassInfo().getFullClassName()).addParameter(attributeName));
        }
        AbstractObjectInfo aoi = this.nnoi.getMetaValueOf(attributeName);
        if (aoi.isAtomicNativeObject()) {
            return aoi.getObject();
        }
        if (aoi.isNonNativeObject()) {
            return new ObjectRepresentationImpl((NonNativeObjectInfo)aoi, this.introspector);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("getValueOf for " + aoi.getOdbType().getName()));
    }

    public void setValueOf(String attributeName, Object value) {
        AbstractObjectInfo aoi = this.introspector.getGenericMetaRepresentation(value, new DefaultInstrumentationCallback());
        this.nnoi.setValueOf(attributeName, aoi);
        this.changedValues.put(attributeName, value);
        this.setChanged();
        this.notifyObservers(new ChangedValueNotification(this.nnoi, this.nnoi.getOid(), attributeName, value));
    }

    public ObjectOid getObjectOid() {
        return this.nnoi.getOid();
    }

    public String getObjectClassName() {
        return this.nnoi.getClassInfo().getFullClassName();
    }

    public final NonNativeObjectInfo getNnoi() {
        return this.nnoi;
    }

    public boolean hasField(String fieldName) {
        ClassAttributeInfo cai = this.nnoi.getClassInfo().getAttributeInfoFromName(fieldName);
        return cai != null;
    }
}

