/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.tool.wrappers.OdbTime;

public class ObjectInfoHeader
implements Serializable {
    private ClassOid classInfoId;
    private AttributeIdentification[] attributesIdentification;
    private ObjectOid oid = null;
    private long creationDate;
    private long updateDate;
    private long objectVersion;
    private int attributePosition;

    public ObjectInfoHeader(ClassOid classInfoId, AttributeIdentification[] attributesIdentification) {
        this.classInfoId = classInfoId;
        this.attributesIdentification = attributesIdentification;
        this.objectVersion = 0L;
        this.creationDate = OdbTime.getCurrentTimeInMs();
    }

    public ObjectInfoHeader() {
        this.objectVersion = 1L;
        this.creationDate = OdbTime.getCurrentTimeInMs();
    }

    public int getNbAttributes() {
        return this.attributesIdentification.length;
    }

    public int getAttributePosition() {
        return this.attributePosition;
    }

    public void setAttributePosition(int position) {
        this.attributePosition = position;
    }

    public ClassOid getClassInfoId() {
        return this.classInfoId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("oid=").append(this.oid).append(" - ");
        buffer.append(" - attr position=").append(this.attributePosition);
        buffer.append(" attrs =[");
        if (this.attributesIdentification != null) {
            for (int i = 0; i < this.attributesIdentification.length; ++i) {
                buffer.append(this.attributesIdentification[i]).append(" ");
            }
        } else {
            buffer.append(" nulls ");
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public AttributeIdentification[] getAttributesIdentification() {
        return this.attributesIdentification;
    }

    public void setAttributesIdentification(AttributeIdentification[] attributesIdentification) {
        this.attributesIdentification = attributesIdentification;
    }

    public ObjectOid getOid() {
        return this.oid;
    }

    public void setOid(ObjectOid oid) {
        this.oid = oid;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(long updateDate) {
        this.updateDate = updateDate;
    }

    public AttributeIdentification getAttributeIdentificationFromId(int attributeId) {
        if (this.attributesIdentification == null) {
            return null;
        }
        for (int i = 0; i < this.attributesIdentification.length; ++i) {
            if (this.attributesIdentification[i].id != attributeId) continue;
            return this.attributesIdentification[i];
        }
        return null;
    }

    public int getAttributeId(int attributeIndex) {
        return this.attributesIdentification[attributeIndex].id;
    }

    public void setClassInfoId(ClassOid classInfoId2) {
        this.classInfoId = classInfoId2;
    }

    public long getObjectVersion() {
        return this.objectVersion;
    }

    public void setObjectVersion(long objectVersion) {
        this.objectVersion = objectVersion;
    }

    public int hashCode() {
        if (this.oid == null) {
            System.out.println("debug:null oid");
        }
        return this.oid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfoHeader other = (ObjectInfoHeader)obj;
        return this.oid.equals(other.oid);
    }

    public void incrementVersionAndUpdateDate() {
        ++this.objectVersion;
        this.updateDate = OdbTime.getCurrentTimeInMs();
    }

    public ObjectInfoHeader duplicate() {
        ObjectInfoHeader oih = new ObjectInfoHeader();
        oih.setAttributesIdentification(this.attributesIdentification);
        oih.setClassInfoId(this.classInfoId);
        oih.setCreationDate(this.creationDate);
        oih.setObjectVersion(this.objectVersion);
        oih.setOid(this.oid);
        oih.setAttributePosition(this.attributePosition);
        oih.setUpdateDate(this.updateDate);
        return oih;
    }
}

