/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModelImpl;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaModel
implements Serializable {
    private Map<String, ClassInfo> rapidAccessForUserClassesByName;
    private Map<String, ClassInfo> rapidAccessForSystemClassesByName;
    private Map<ClassOid, ClassInfo> rapidAccessForClassesByOid;
    private IOdbList<ClassInfo> allClassInfos;
    private boolean hasChanged;
    protected transient ClassPool classPool;
    protected NeoDatisConfig neoDatisConfig;

    public MetaModel(NeoDatisConfig config) {
        this.neoDatisConfig = config;
        this.classPool = this.neoDatisConfig.getCoreProvider().getClassPool();
        this.rapidAccessForUserClassesByName = new OdbHashMap<String, ClassInfo>(10);
        this.rapidAccessForSystemClassesByName = new OdbHashMap<String, ClassInfo>(10);
        this.rapidAccessForClassesByOid = new OdbHashMap<ClassOid, ClassInfo>(10);
        this.allClassInfos = new OdbArrayList<ClassInfo>();
    }

    public void addClass(ClassInfo classInfo, boolean forceAdd) {
        boolean existClass = this.existClass(classInfo.getFullClassName());
        if (!forceAdd && existClass) {
            return;
        }
        if (existClass) {
            this.allClassInfos.remove(classInfo);
        }
        if (classInfo.isSystemClass()) {
            this.rapidAccessForSystemClassesByName.put(classInfo.getFullClassName(), classInfo);
        } else {
            this.rapidAccessForUserClassesByName.put(classInfo.getFullClassName(), classInfo);
        }
        this.rapidAccessForClassesByOid.put(classInfo.getOid(), classInfo);
        this.allClassInfos.add(classInfo);
    }

    public void addClasses(ClassInfoList ciList) {
        Iterator<ClassInfo> iterator = ciList.getClassInfos().iterator();
        while (iterator.hasNext()) {
            this.addClass(iterator.next(), false);
        }
    }

    public boolean existClass(String fullClassName) {
        boolean exist = this.rapidAccessForSystemClassesByName.containsKey(fullClassName);
        if (exist) {
            return true;
        }
        exist = this.rapidAccessForUserClassesByName.containsKey(fullClassName);
        return exist;
    }

    public String toString() {
        return this.rapidAccessForUserClassesByName.values() + "/" + this.rapidAccessForSystemClassesByName.values();
    }

    public IOdbList<ClassInfo> getAllClasses() {
        return this.allClassInfos;
    }

    public Collection<ClassInfo> getUserClasses() {
        return this.rapidAccessForUserClassesByName.values();
    }

    public Collection<ClassInfo> getSystemClasses() {
        return this.rapidAccessForSystemClassesByName.values();
    }

    public int getNumberOfClasses() {
        return this.allClassInfos.size();
    }

    public int getNumberOfUserClasses() {
        return this.rapidAccessForUserClassesByName.size();
    }

    public int getNumberOfSystemClasses() {
        return this.rapidAccessForSystemClassesByName.size();
    }

    public ClassInfo getClassInfoFromId(ClassOid coid) {
        return this.rapidAccessForClassesByOid.get(coid);
    }

    public ClassInfo getClassInfo(String fullClassName, boolean throwExceptionIfDoesNotExist) {
        ClassInfo ci = this.rapidAccessForSystemClassesByName.get(fullClassName);
        if (ci != null) {
            return ci;
        }
        ci = this.rapidAccessForUserClassesByName.get(fullClassName);
        if (ci != null) {
            return ci;
        }
        if (throwExceptionIfDoesNotExist) {
            throw new NeoDatisRuntimeException(NeoDatisError.META_MODEL_CLASS_NAME_DOES_NOT_EXIST.addParameter(fullClassName));
        }
        return null;
    }

    public ClassInfo getLastClassInfo() {
        return this.allClassInfos.get(this.allClassInfos.size() - 1);
    }

    public int slowGetUserClassInfoIndex(ClassInfo ci) {
        Iterator<ClassInfo> iterator = this.rapidAccessForUserClassesByName.values().iterator();
        int i = 0;
        ClassInfo ci2 = null;
        while (iterator.hasNext()) {
            ci2 = iterator.next();
            if (ci2.getOid() == ci.getOid()) {
                return i;
            }
            ++i;
        }
        throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DOES_NOT_EXIST_IN_META_MODEL.addParameter(ci.getFullClassName()));
    }

    public ClassInfo getClassInfo(int index) {
        return this.allClassInfos.get(index);
    }

    public ClassInfo slowGetUserClassInfo(int index) {
        Iterator<ClassInfo> iterator = this.rapidAccessForUserClassesByName.values().iterator();
        int i = 0;
        ClassInfo ci = null;
        while (iterator.hasNext()) {
            ci = iterator.next();
            if (i == index) {
                return ci;
            }
            ++i;
        }
        throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DOES_NOT_EXIST_IN_META_MODEL.addParameter(" with index " + index));
    }

    public void clear() {
        this.rapidAccessForSystemClassesByName.clear();
        this.rapidAccessForUserClassesByName.clear();
        this.rapidAccessForSystemClassesByName = null;
        this.rapidAccessForUserClassesByName = null;
        this.allClassInfos.clear();
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public abstract Collection<ClassInfo> getChangedClassInfo();

    public abstract void resetChangedClasses();

    public abstract void addChangedClass(ClassInfo var1);

    public static MetaModel fromClassInfos(IOdbList<ClassInfo> classInfos, NeoDatisConfig neoDatisConfig) {
        MetaModelImpl metaModel = new MetaModelImpl(neoDatisConfig);
        int nbClasses = classInfos.size();
        for (int i = 0; i < nbClasses; ++i) {
            metaModel.addClass(classInfos.get(i), false);
        }
        return metaModel;
    }

    public IOdbList<ClassInfo> getPersistentSubclassesOf(String fullClassName) {
        OdbArrayList<ClassInfo> result = new OdbArrayList<ClassInfo>();
        Iterator<String> classNames = this.rapidAccessForUserClassesByName.keySet().iterator();
        String oneClassName = null;
        Class theClass = this.classPool.getClass(fullClassName);
        Class oneClass = null;
        while (classNames.hasNext()) {
            oneClassName = classNames.next();
            if (oneClassName.equals(fullClassName)) {
                result.add(this.getClassInfo(oneClassName, true));
                continue;
            }
            oneClass = this.classPool.getClass(oneClassName);
            if (!theClass.isAssignableFrom(oneClass)) continue;
            result.add(this.getClassInfo(oneClassName, true));
        }
        return result;
    }

    public abstract MetaModel duplicate();

    public boolean hasCyclicReference(ClassInfo ci) {
        return this.hasCyclicReference(ci, new OdbHashMap<String, ClassInfo>());
    }

    private boolean hasCyclicReference(ClassInfo ci, Map<String, ClassInfo> alreadyVisitedClasses) {
        ClassAttributeInfo cai = null;
        boolean hasCyclicRef = false;
        String fullClassName = ci.getFullClassName();
        if (alreadyVisitedClasses.get(fullClassName) != null) {
            return true;
        }
        OdbHashMap<String, ClassInfo> localMap = new OdbHashMap();
        alreadyVisitedClasses.put(fullClassName, ci);
        for (int i = 0; i < ci.getAttributes().size(); ++i) {
            cai = ci.getAttributeInfo(i);
            if (cai.isNative()) continue;
            localMap = new OdbHashMap<String, ClassInfo>(alreadyVisitedClasses);
            hasCyclicRef = this.hasCyclicReference(this.getClassInfoFromId(cai.getAttributeClassOid()), localMap);
            if (!hasCyclicRef) continue;
            return true;
        }
        return false;
    }
}

