/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;

public class ClassAttributeInfo
implements Serializable {
    private int id;
    private ClassOid ownerClassInfoOid;
    private String className;
    private String name;
    private boolean isIndex;
    private ODBType attributeType;
    private Class nativeClass;
    private ClassOid attributeClassOid;

    public ClassAttributeInfo() {
    }

    public ClassAttributeInfo(int attributeId, String name, String fullClassName, ClassOid attributeCiOid, ClassOid ownerCiOid) {
        this(attributeId, name, null, fullClassName, attributeCiOid, ownerCiOid);
    }

    public ClassAttributeInfo(int attributeId, String name, Class nativeClass, String fullClassName, ClassOid attributeCiOid, ClassOid ownerCiOid) {
        this.id = attributeId;
        this.name = name;
        this.nativeClass = nativeClass;
        this.className = fullClassName;
        if (nativeClass != null) {
            this.attributeType = ODBType.getFromClass(nativeClass);
        } else if (fullClassName != null) {
            this.attributeType = ODBType.getFromName(fullClassName);
        }
        if (attributeCiOid != null) {
            this.attributeClassOid = attributeCiOid;
        }
        if (ownerCiOid != null) {
            this.ownerClassInfoOid = ownerCiOid;
        }
        this.isIndex = false;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public void setIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNative() {
        return this.attributeType.isNative();
    }

    public boolean isNonNative() {
        return !this.attributeType.isNative();
    }

    public ClassOid getAttributeClassOid() {
        return this.attributeClassOid;
    }

    public void setAttributeClassOid(ClassOid coid) {
        this.attributeClassOid = coid;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("id=").append(this.id).append(" name=").append(this.name).append(" | is Native=").append(this.isNative()).append(" | type=").append(this.getClassName()).append(" | isIndex=").append(this.isIndex);
        return buffer.toString();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setAttributeType(ODBType attributeType) {
        this.attributeType = attributeType;
    }

    public ODBType getAttributeType() {
        return this.attributeType;
    }

    public Class getNativeClass() {
        return this.nativeClass;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setOwnerClassInfoOid(ClassOid ciId) {
        this.ownerClassInfoOid = ciId;
    }

    public ClassOid getOwnerClassInfoOid() {
        return this.ownerClassInfoOid;
    }
}

