/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.instance;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ClassPoolImpl
implements ClassPool {
    private Map<String, Class> classMap = new OdbHashMap<String, Class>();
    private Map<String, Constructor> construtorsMap = new OdbHashMap<String, Constructor>();
    private NeoDatisConfig neoDatisConfig;

    public ClassPoolImpl(NeoDatisConfig config) {
        this.neoDatisConfig = config;
    }

    public void reset() {
        this.classMap.clear();
        this.construtorsMap.clear();
    }

    public synchronized Class getClass(String className) {
        Class<?> clazz = this.classMap.get(className);
        if (clazz == null) {
            try {
                ClassLoader cl = this.neoDatisConfig.getClassLoader();
                if (cl == null) {
                    throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Class loader is null!"));
                }
                clazz = cl.loadClass(className);
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.CLASS_POOL_CREATE_CLASS.addParameter(className), (Throwable)e);
            }
            this.classMap.put(className, clazz);
        }
        return clazz;
    }

    public Constructor getConstructor(String className) {
        return this.construtorsMap.get(className);
    }

    public void addConstructor(String className, Constructor constructor) {
        this.construtorsMap.put(className, constructor);
    }
}

