/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree.kv;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.impl.singlevalue.BTreeNodeSingleValuePerKey;
import org.neodatis.odb.core.btree.kv.Position;

public class KVNode
extends BTreeNodeSingleValuePerKey {
    protected Object id;
    protected Object[] children;
    protected Object parentId;
    protected KVNode parent;

    public KVNode(Object id, IBTree btree) {
        super(btree);
        this.id = id;
        this.children = new Object[btree.getDegree() * 2];
    }

    public KVNode(IBTree btree, long id, long parentId, int size, Long[] keys, Position[] positions, Long[] children, int nbKeys, int nbChildren) {
        super(btree);
        this.id = id;
        this.parentId = parentId;
        this.children = children;
        for (int i = 0; i < size; ++i) {
            this.setKeyAndValueAt(keys[i], positions[i], i);
        }
        this.setNbKeys(nbKeys);
        this.setNbChildren(nbChildren);
    }

    public IBTreeNode getChildAt(int index, boolean throwExceptionIfNotExist) {
        if (this.children[index] == null) {
            if (throwExceptionIfNotExist) {
                throw new BTreeException("Trying to load null child node at index " + index);
            }
            return null;
        }
        Object id = this.children[index];
        if (id == null) {
            return null;
        }
        IBTreeNode child = this.btree.getPersister().loadNodeById(id);
        if (child != null) {
            child.setParent(this);
        }
        return child;
    }

    public IBTreeNode getParent() {
        if (this.parent == null) {
            this.parent = (KVNode)this.btree.getPersister().loadNodeById(this.parentId);
        }
        return this.parent;
    }

    public Object getParentId() {
        return this.parentId;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void deleteChildAt(int index) {
        this.children[index] = null;
        --this.nbChildren;
    }

    public void moveChildFromTo(int sourceIndex, int destinationIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[sourceIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + sourceIndex);
        }
        this.children[destinationIndex] = this.children[sourceIndex];
    }

    public void setNullChildAt(int childIndex) {
        this.children[childIndex] = null;
    }

    public Object getChildIdAt(int childIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[childIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + childIndex);
        }
        return this.children[childIndex];
    }

    public Object getValueAsObjectAt(int index) {
        return this.getValueAt(index);
    }

    protected void init() {
    }

    public void setParent(IBTreeNode node) {
        this.parent = (KVNode)node;
        this.parentId = this.parent.getId();
    }

    public Object getId() {
        return this.id;
    }

    public void setChildAt(IBTreeNode node, int childIndex, int indexDestination, boolean throwExceptionIfDoesNotExist) {
        IBTreeNode child = node.getChildAt(childIndex, throwExceptionIfDoesNotExist);
        if (child != null) {
            this.children[indexDestination] = child.getId();
        }
    }

    public void setChildAt(IBTreeNode child, int index) {
        this.children[index] = child.getId();
    }

    public void setId(Object id) {
        this.id = id;
    }
}

