/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.btree.BTreeError;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer4.engine.Dummy;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.trigger.CommitListener;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class LazyODBBTreePersister
implements IBTreePersister,
CommitListener {
    public static final String LOG_ID = "LazyODBBTreePersister";
    private Map<ObjectOid, Object> oids = new HashMap<ObjectOid, Object>();
    private OdbHashMap<Object, Integer> modifiedObjectOids;
    private IOdbList<ObjectOid> modifiedObjectOidList;
    private SessionEngine engine;
    private IBTree tree;
    private static Map<ObjectOid, Object> smap = null;
    private static Map<Object, Integer> smodifiedObjects = null;
    public static int nbSaveNodes = 0;
    public static int nbSaveNodesInCache = 0;
    public static int nbSaveTree = 0;
    public static int nbLoadNodes = 0;
    public static int nbLoadTree = 0;
    public static int nbLoadNodesFromCache = 0;
    private int nbPersist;
    private Map<Class, ClassOid> classOids = new HashMap<Class, ClassOid>();
    protected InstanceBuilderContext ibc;
    protected boolean debug;

    public LazyODBBTreePersister(ODB odb) {
        this(Dummy.getEngine(odb));
    }

    public LazyODBBTreePersister(SessionEngine engine) {
        this.modifiedObjectOids = new OdbHashMap();
        this.modifiedObjectOidList = new OdbArrayList<ObjectOid>(500);
        this.engine = engine;
        this.engine.getSession().addCommitListener(this);
        smap = this.oids;
        smodifiedObjects = this.modifiedObjectOids;
        this.ibc = new InstanceBuilderContext();
        this.debug = engine.getSession().getConfig().isDebugEnabled(LOG_ID);
    }

    public IBTreeNode loadNodeById(Object id) {
        ObjectOid oid = (ObjectOid)id;
        IBTreeNode node = (IBTreeNode)this.oids.get(oid);
        if (node != null) {
            ++nbLoadNodesFromCache;
            return node;
        }
        ++nbLoadNodes;
        try {
            if (this.debug) {
                DLogger.debug("Loading node with id " + oid);
            }
            if (oid == null) {
                throw new NeoDatisRuntimeException(BTreeError.INVALID_ID_FOR_BTREE.addParameter(oid));
            }
            IBTreeNode pn = (IBTreeNode)this.engine.getObjectFromOid(oid, true, this.ibc);
            pn.setId(oid);
            if (this.tree != null) {
                pn.setBTree(this.tree);
            }
            this.oids.put(oid, pn);
            return pn;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException((IError)BTreeError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public Object saveNode(IBTreeNode node) {
        ObjectOid oid = null;
        if (node.getId() == null) {
            try {
                ++nbSaveNodes;
                oid = this.getNextIdFor(node.getClass());
                node.setId(oid);
                oid = this.engine.store(oid, node);
                if (this.debug) {
                    DLogger.debug("Saved node id " + oid + " : class " + node.getClass().getName());
                }
                if (this.tree != null && node.getBTree() == null) {
                    node.setBTree(this.tree);
                }
                this.oids.put(oid, node);
                return oid;
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(BTreeError.INTERNAL_ERROR.addParameter("While saving node"), (Throwable)e);
            }
        }
        ++nbSaveNodesInCache;
        oid = (ObjectOid)node.getId();
        this.oids.put(oid, node);
        this.addModifiedOid(oid);
        return oid;
    }

    public void close() throws Exception {
        this.persist();
        this.engine.getSession().commit();
        this.engine.close();
    }

    public IBTree loadBTree(Object id) {
        ++nbLoadTree;
        ObjectOid oid = (ObjectOid)id;
        try {
            if (this.debug) {
                DLogger.debug("Loading btree with id " + oid);
            }
            if (oid == null) {
                throw new NeoDatisRuntimeException(BTreeError.INVALID_ID_FOR_BTREE.addParameter("null"));
            }
            this.tree = (IBTree)this.engine.getObjectFromOid(oid, true, this.ibc);
            this.tree.setId(oid);
            this.tree.setPersister(this);
            IBTreeNode root = this.tree.getRoot();
            root.setBTree(this.tree);
            return this.tree;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(BTreeError.INTERNAL_ERROR.addParameter(e.getMessage()), (Throwable)e);
        }
    }

    public OID saveBTree(IBTree treeToSave) {
        ++nbSaveTree;
        try {
            ObjectOid oid = (ObjectOid)treeToSave.getId();
            if (oid == null) {
                oid = this.getNextIdFor(treeToSave.getClass());
                treeToSave.setId(oid);
                oid = this.engine.store(oid, treeToSave);
                if (this.debug) {
                    DLogger.debug("Saved btree " + treeToSave.getId() + " with id " + oid + " and  root " + treeToSave.getRoot());
                }
                if (this.tree == null) {
                    this.tree = treeToSave;
                }
                this.oids.put(oid, treeToSave);
            } else {
                this.oids.put(oid, treeToSave);
                this.addModifiedOid(oid);
            }
            return oid;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException((IError)BTreeError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public ObjectOid getNextIdFor(Class clazz) throws IOException {
        ClassOid coid = this.classOids.get(clazz);
        if (coid == null) {
            coid = this.engine.getSession().getClassInfo(clazz.getName()).getOid();
            this.classOids.put(clazz, coid);
        }
        return this.engine.getStorageEngine().getOidGenerator().createObjectOid(coid);
    }

    public void persist() {
        ++this.nbPersist;
        if (this.debug) {
            DLogger.debug("persist " + this.nbPersist + " : Saving " + this.modifiedObjectOids.size() + " objects - " + this.hashCode());
        }
        Object var1_1 = null;
        int nbCommited = 0;
        long t0 = 0L;
        long t1 = 0L;
        int i = 0;
        int size = this.modifiedObjectOids.size();
        for (OID oID : this.modifiedObjectOidList) {
            if (oID == null) continue;
            ++nbCommited;
            try {
                t0 = OdbTime.getCurrentTimeInMs();
                Object o = this.oids.get(oID);
                this.engine.store(o);
                t1 = OdbTime.getCurrentTimeInMs();
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(BTreeError.INTERNAL_ERROR.addParameter("Error while storing object with oid " + oID), (Throwable)e);
            }
            if (this.debug) {
                DLogger.debug("Committing oid " + oID + " | " + i + "/" + size + " | " + (t1 - t0));
            }
            ++i;
        }
        if (this.debug) {
            DLogger.debug(nbCommited + " commits / " + size);
        }
    }

    public void afterCommit() {
    }

    public void beforeCommit() {
        this.persist();
        this.clear();
    }

    public Object deleteNode(IBTreeNode o) {
        ObjectOid oid = this.engine.delete(o, true);
        this.oids.remove(oid);
        Integer position = this.modifiedObjectOids.remove2(oid);
        if (position != null) {
            this.modifiedObjectOidList.set(position, null);
        }
        return o;
    }

    public void setBTree(IBTree tree) {
        this.tree = tree;
    }

    public static void resetCounters() {
        nbSaveNodes = 0;
        nbSaveTree = 0;
        nbSaveNodesInCache = 0;
        nbLoadNodes = 0;
        nbLoadTree = 0;
        nbLoadNodesFromCache = 0;
    }

    public static StringBuffer counters() {
        StringBuffer buffer = new StringBuffer("save nodes=").append(nbSaveNodes).append(",").append(nbLoadNodesFromCache).append(" | save tree=").append(nbSaveTree).append(" | loadNodes=").append(nbLoadNodes).append(",").append(nbLoadNodesFromCache).append(" | load tree=").append(nbLoadTree);
        if (smap != null && smodifiedObjects != null) {
            buffer.append(" | map size=").append(smap.size()).append(" | modObjects size=").append(smodifiedObjects.size());
        }
        return buffer;
    }

    public void clear() {
        this.oids.clear();
        this.modifiedObjectOids.clear();
        this.modifiedObjectOidList.clear();
    }

    public void clearModified() {
        this.modifiedObjectOids.clear();
        this.modifiedObjectOidList.clear();
    }

    public void flush() {
        this.persist();
        this.clearModified();
    }

    protected void addModifiedOid(ObjectOid oid) {
        Object o = this.modifiedObjectOids.get(oid);
        if (o != null) {
            return;
        }
        this.modifiedObjectOidList.add(oid);
        this.modifiedObjectOids.put(oid, new Integer(this.modifiedObjectOidList.size() - 1));
    }
}

