/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.ant;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.neodatis.odb.NeoDatisContext;
import org.neodatis.odb.NeoDatisObject;
import org.neodatis.odb.ant.User;
import org.neodatis.odb.core.context.NeoDatisContextImpl;

public class JavaAssistUtility {
    public void makeNeoDatisClass(String className, String directoryToWrite) throws Exception {
        try {
            CtMethod[] methods;
            System.out.println("Enhancing class " + className);
            Class<?> c = Class.forName(className);
            System.out.println("C from java " + c.getName());
            ClassPool pool = ClassPool.getDefault();
            CtClass cc = pool.get(className);
            cc.stopPruning(true);
            cc.defrost();
            String fieldNameContext = "__neoDatisContext__";
            String code = String.format("protected %s %s = new %s();", NeoDatisContext.class.getName(), fieldNameContext, NeoDatisContextImpl.class.getName());
            System.out.println(code);
            CtField context = CtField.make((String)code, (CtClass)cc);
            cc.addField(context);
            for (CtMethod method : methods = cc.getMethods()) {
                if (!method.getName().startsWith("set")) continue;
                method.insertAfter(String.format("{%s.markAsChanged();}", fieldNameContext));
                System.out.println(method.toString());
            }
            cc.addInterface(pool.getCtClass(NeoDatisObject.class.getName()));
            CtMethod getterContext = CtNewMethod.make((String)String.format("public %s getNeoDatisContext() { return %s; }", NeoDatisContext.class.getName(), fieldNameContext), (CtClass)cc);
            CtMethod setterContext = CtNewMethod.make((String)String.format("public void setNeoDatisContext(%s context) { %s = context; }", NeoDatisContext.class.getName(), fieldNameContext), (CtClass)cc);
            cc.addMethod(getterContext);
            cc.addMethod(setterContext);
            String fullName = directoryToWrite + "/" + cc.getName().replace(".", "/") + ".class";
            cc.writeFile(directoryToWrite);
            System.out.println("Writing instrumented class " + cc.getSimpleName() + " to " + fullName);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
            throw e;
        }
    }

    public static String getClassDescription(String className) throws ClassNotFoundException {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Class name=").append(className).append("\n");
        Class<?> aClass = Class.forName(className);
        for (i = 0; i < aClass.getDeclaredFields().length; ++i) {
            buffer.append(i + 1).append(":").append(aClass.getDeclaredFields()[i].getName() + " : " + aClass.getDeclaredFields()[i].getType().getName()).append("\n");
        }
        for (i = 0; i < aClass.getDeclaredMethods().length; ++i) {
            buffer.append(i + 1).append(":").append(aClass.getDeclaredMethods()[i].getName()).append("\n");
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        JavaAssistUtility jau = new JavaAssistUtility();
        String className = User.class.getName();
        jau.makeNeoDatisClass(className, "tmp");
    }
}

