/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.memory.FileAndBlockKey;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.tool.DLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMA {
    protected NdfsTransaction ndfsTransaction;
    protected Map<FileAndBlockKey, byte[]> byteArrayByBlockId;
    protected Map<NdfsFile, Collection<Bytes>> blocksByFile;

    public TMA(NdfsTransaction ndfsTransaction) {
        this.ndfsTransaction = ndfsTransaction;
        this.byteArrayByBlockId = new HashMap<FileAndBlockKey, byte[]>();
        this.blocksByFile = new HashMap<NdfsFile, Collection<Bytes>>();
    }

    public void add(NdfsFile file, Bytes bytes) {
        int nbBlocks = bytes.getNbBlocks();
        long blockId = bytes.getOffset() / (long)this.ndfsTransaction.getNdfs().getProperties().getBlockSize();
        for (int i = 0; i < nbBlocks; ++i) {
            byte[] block = bytes.getByteArray(i);
            FileAndBlockKey key = new FileAndBlockKey(file, blockId + (long)i);
            this.byteArrayByBlockId.put(key, block);
            if (!NdfsConfig.debug()) continue;
            DLogger.info(String.format("TMA:tid=%d : adding block id %d in transaction for file %s (fid=%d)", this.ndfsTransaction.getId(), blockId + (long)i, file.getName(), file.getId()));
        }
        Collection<Bytes> blocksList = this.blocksByFile.get(file);
        if (blocksList == null) {
            blocksList = new ArrayList<Bytes>();
            this.blocksByFile.put(file, blocksList);
        }
        blocksList.add(bytes);
        if (NdfsConfig.debug()) {
            DLogger.info(String.format("TMA:tid=%d : adding bytes (size=%d) for file %s, nb [blocks]=%d ", this.ndfsTransaction.getId(), bytes.getRealSize(), file.getName(), blocksList.size()));
        }
    }

    public Map<FileAndBlockKey, byte[]> getByteArrayByBlockId() {
        return this.byteArrayByBlockId;
    }

    public Map<NdfsFile, Collection<Bytes>> getBlocksByFile() {
        return this.blocksByFile;
    }

    public void clear() {
        this.byteArrayByBlockId.clear();
        this.blocksByFile.clear();
    }
}

