/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import org.neodatis.fs.Block;
import org.neodatis.fs.FileSystemProperties;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.io.BlockReader;
import org.neodatis.fs.memory.FileAndBlockKey;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.tool.DLogger;

public class NdfsFileImpl
implements NdfsFile {
    protected long id;
    protected String directory;
    protected String name;
    protected String fullName;
    protected NDFS ndfs;
    protected NdfsTransaction transaction;
    protected BlockReader blockReader;
    protected long blockSize;
    protected boolean debug;

    public NdfsFileImpl(NDFS ndfs, long id, String fullName) {
        File file = new File(new File(fullName).getAbsolutePath());
        String directory = null;
        String name = file.getName();
        this.init(ndfs, id, directory, name);
    }

    private void init(NDFS ndfs, long id, String directory, String name) {
        this.debug = NdfsConfig.debug();
        this.ndfs = ndfs;
        this.id = id;
        this.transaction = null;
        this.directory = directory;
        this.name = name;
        this.fullName = directory == null ? new File(new StringBuffer(ndfs.getProperties().getBaseDirectory()).append("/").append(name).toString()).getAbsolutePath() : new File(new StringBuffer(ndfs.getProperties().getBaseDirectory()).append("/").append(directory).append("/").append(name).toString()).getAbsolutePath();
        this.blockReader = new BlockReader(this);
        this.blockSize = ndfs.getProperties().getBlockSize();
    }

    public NdfsFileImpl(NDFS ndfs, long id, String directory, String name) {
        this.init(ndfs, id, directory, name);
    }

    public NdfsFileImpl(NdfsTransaction transaction, long id, String directory, String name) {
        this(transaction.getNdfs(), id, directory, name);
        this.transaction = transaction;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void createDirectory() {
        new File(this.directory).mkdirs();
    }

    public FileSystemProperties getProperties() {
        return this.ndfs.getProperties();
    }

    public Bytes read(long position, long length) {
        long blockId = position / this.blockSize;
        long offsetPosition = blockId * this.blockSize;
        int delta = (int)(position - offsetPosition);
        FileAndBlockKey key = new FileAndBlockKey(this, blockId);
        Bytes bytes = null;
        boolean ok = false;
        long currentPosition = offsetPosition;
        while (!ok) {
            Block block = this.readOneBlock(currentPosition);
            if (bytes != null) {
                bytes.append(block.bytes);
            }
            if ((long)(bytes.getRealSize() - delta) >= length) {
                ok = true;
            }
            currentPosition += this.blockSize;
        }
        return bytes;
    }

    protected Block readOneBlock(long position) {
        long blockId = position / this.blockSize;
        long offsetPosition = blockId * this.blockSize;
        FileAndBlockKey key = new FileAndBlockKey(this, blockId);
        byte[] bytes = this.tryToGetFromMemory(key);
        if (bytes == null) {
            bytes = this.blockReader.readBlock((long)blockId).bytes;
            if (this.debug) {
                DLogger.debug("NdfsFile:Reading block id " + blockId + " with size = " + bytes.length);
            }
            if (this.transaction != null) {
                this.transaction.getTma().getByteArrayByBlockId().put(key, bytes);
            }
        }
        return new Block(this, blockId, bytes);
    }

    public byte[] tryToGetFromMemory(FileAndBlockKey key) {
        if (this.transaction == null) {
            return null;
        }
        byte[] bytes = this.transaction.getTma().getByteArrayByBlockId().get(key);
        if (bytes != null) {
            return bytes;
        }
        bytes = this.transaction.getGma().getByteArrayByBlockId().get(key);
        return bytes;
    }

    public void write(Bytes bytes) {
        if (this.transaction != null) {
            this.transaction.writeTo(this, bytes);
        } else {
            this.writeDirect(bytes);
        }
    }

    public void writeDirect(Bytes bytes) {
        this.ndfs.getSyncWriter(this).writeTo(bytes);
    }

    public long getSize() {
        return new File(this.getFullName()).length();
    }

    public String toString() {
        return this.fullName + " - fid=" + this.id;
    }

    public NDFS getNdfs() {
        return this.ndfs;
    }

    public long append(Bytes bytes) {
        long position = this.getSize();
        bytes.setOffset(position);
        this.write(bytes);
        return position;
    }

    public long appendDirect(Bytes bytes) {
        long position = this.getSize();
        bytes.setOffset(position);
        this.writeDirect(bytes);
        return position;
    }

    public Bytes readAll() {
        return this.read(0L, this.getSize());
    }
}

