/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.Id;
import org.neodatis.fs.FileSystemProperties;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsException;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.io.IOFlusher;
import org.neodatis.fs.io.NdfsFileImpl;
import org.neodatis.fs.io.SplittedNDFSFileImpl;
import org.neodatis.fs.io.SyncBlockWriter;
import org.neodatis.fs.io.SyncWriters;
import org.neodatis.fs.memory.GMA;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.fs.transaction.NdfsTransactionImpl;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.BytesHelper;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.tool.DLogger;

public class NDFSImpl
implements NDFS {
    protected static final String MAIN = "main.ndfs";
    protected static final String FILES = "files.ndfs";
    protected static final String IDS = "ids.ndfs";
    protected FileSystemProperties properties;
    protected GMA gma;
    protected int nextTransactionId;
    protected boolean isClosed;
    protected SyncWriters syncWriters;
    protected IOFlusher flusher;
    protected Thread flusherThread;
    protected boolean debug;
    protected ByteArrayConverter converter;
    protected long creationTimeStamp;
    protected Map<Long, Long> fileNamesPositionById;
    protected Map<Long, String> fileNamesById;
    public Map<String, Long> fileIdsByName;
    protected NdfsFile mainFile;
    protected NdfsFile fileIds;
    protected NdfsFile fileNames;
    protected String characterEncoding;
    protected NeoDatisConfig config;

    public NDFSImpl(FileSystemProperties properties, NeoDatisConfig config) {
        this.config = config;
        this.debug = NdfsConfig.debug();
        if (this.debug) {
            DLogger.debug("Starting NDFS with base directory=" + properties.getBaseDirectory());
        }
        this.characterEncoding = "UTF-8";
        this.properties = properties;
        this.gma = new GMA();
        this.nextTransactionId = 1;
        this.isClosed = false;
        this.syncWriters = new SyncWriters(this);
        this.converter = new ByteArrayConverterImpl(this.debug, this.characterEncoding, config);
        this.flusher = new IOFlusher(this);
        this.fileIdsByName = new HashMap<String, Long>();
        this.fileNamesPositionById = new HashMap<Long, Long>();
        this.fileNamesById = new HashMap<Long, String>();
        this.loadDefinitions();
        this.flusherThread = new Thread(this.flusher);
        this.flusherThread.start();
    }

    private void loadDefinitions() {
        String fullDirectoryName = new File(this.properties.getBaseDirectory()).getAbsolutePath();
        File file = new File(fullDirectoryName);
        boolean exist = file.exists();
        if (exist) {
            this.mainFile = new NdfsFileImpl(this, 1L, MAIN);
            this.fileNames = new NdfsFileImpl(this, 2L, FILES);
            this.fileIds = new NdfsFileImpl(this, 3L, IDS);
            this.loadFileDefinition();
        } else {
            file.getParentFile().mkdirs();
            this.createMainFiles();
        }
    }

    private void createMainFiles() {
        this.creationTimeStamp = System.nanoTime();
        this.mainFile = new NdfsFileImpl(this, 1L, MAIN);
        this.fileNames = new NdfsFileImpl(this, 2L, FILES);
        this.fileIds = new NdfsFileImpl(this, 3L, IDS);
        if (this.debug) {
            DLogger.debug("NDFS:Creating main ndfs file " + this.mainFile.getFullName() + " - creation timestamp=" + this.creationTimeStamp);
        }
        Bytes bytes = BytesFactory.getBytes();
        this.converter.byteToByteArray((byte)1, bytes, 0, "status");
        this.converter.longToByteArray(this.creationTimeStamp, bytes, 1, "creation");
        this.mainFile.writeDirect(bytes);
    }

    public NdfsFile getFile(String fileName) {
        long id = this.getFileIdFromFullFileName(fileName);
        return new NdfsFileImpl(this, id, fileName);
    }

    public NdfsFile getSplitFile(String fileName, int maxNbBlockPerFile) {
        long id = this.getFileIdFromFullFileName(fileName);
        return new SplittedNDFSFileImpl(this, id, fileName, maxNbBlockPerFile);
    }

    private void loadIds() {
        File files = new File(String.format("%s/%s", this.properties.getBaseDirectory(), FILES));
    }

    public long getFileIdFromFullFileName(String fileName) {
        Long id = this.fileIdsByName.get(fileName);
        if (id == null) {
            id = this.registerNewFile(fileName);
        }
        return id;
    }

    public Long registerNewFile(String fileName) {
        long fileId = Id.getNew();
        Bytes bytes = BytesFactory.getBytes();
        this.converter.stringToByteArray(fileName, false, bytes, 0, "name");
        long position = this.fileNames.append(bytes);
        Bytes bytes2 = BytesFactory.getBytes();
        this.converter.longToByteArray(fileId, bytes2, 0, "id");
        this.converter.longToByteArray(position, bytes2, 8, "position");
        this.fileIds.append(bytes2);
        if (this.debug) {
            DLogger.debug("NDFS: new file " + fileName + " with id " + fileId);
        }
        Long lid = new Long(fileId);
        this.fileIdsByName.put(fileName, lid);
        this.fileNamesById.put(lid, fileName);
        return new Long(fileId);
    }

    private void loadFileDefinition() {
        BytesHelper bytes = new BytesHelper(this.mainFile.read(0L, 9L), this.debug, this.characterEncoding, this.config);
        byte status = bytes.readByte(0);
        this.creationTimeStamp = bytes.readLong(1);
        if (status == 1) {
            this.recoverFromDirtyShutdown();
        }
        bytes.writeByte((byte)1, 0, "status");
        this.mainFile.writeDirect(bytes.getBytes());
        if (this.debug) {
            DLogger.debug("NDFS:Reading main ndfs file " + this.mainFile.getFullName() + " - status = " + status + " - timestamp=" + this.creationTimeStamp);
        }
        BytesHelper b = new BytesHelper(this.fileIds.readAll(), this.debug, this.characterEncoding, this.config);
        BytesHelper b2 = new BytesHelper(this.fileNames.readAll(), this.debug, this.characterEncoding, this.config);
        ReadSize readSize2 = new ReadSize();
        ReadSize readSize3 = new ReadSize();
        while (readSize2.get() < b.getBytes().getRealSize()) {
            long id = b.readLong(readSize2.get(), readSize2, "id");
            long position = b.readLong(readSize2.get(), readSize2, "position");
            this.fileNamesPositionById.put(new Long(id), new Long(position));
            String name = b2.readString(false, (int)position, readSize3, "name");
            if (id == 0L) break;
            if (this.debug) {
                DLogger.debug("\tFile with id " + id + " - position=" + position + " - name=" + name);
            }
            Long lid = new Long(id);
            this.fileIdsByName.put(name, lid);
            this.fileNamesById.put(lid, name);
        }
        if (this.debug) {
            DLogger.debug("NDFS:Loading " + this.fileNamesPositionById.size() + " file ids");
        }
    }

    private void recoverFromDirtyShutdown() {
        NdfsFile[] transactionFiles;
        DLogger.debug("NDFS:FileSystem has not been closed properly, check for pending transactions");
        for (NdfsFile file : transactionFiles = this.getTransactionFiles()) {
            this.recoverOneTransaction(file);
        }
    }

    private void recoverOneTransaction(NdfsFile file) {
        byte status = NdfsTransactionImpl.getStatusOfTransaction(file);
        if (status != 1) {
            DLogger.debug("Transaction file " + file.getName() + " has status " + status + " => delete it");
        }
    }

    private NdfsFile[] getTransactionFiles() {
        File transactionDirectory = new File(this.getProperties().getTransactionDirectory(true));
        if (!transactionDirectory.exists()) {
            return new NdfsFile[0];
        }
        File[] files = transactionDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".transaction");
            }
        });
        NdfsFile[] tfiles = new NdfsFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            tfiles[i] = new NdfsFileImpl(this, System.nanoTime(), files[i].getParentFile().getAbsolutePath(), files[i].getName());
        }
        return tfiles;
    }

    public NdfsTransaction startTransaction() throws NdfsException {
        long transactionId = this.getNextTransactionId();
        NdfsTransactionImpl transaction = new NdfsTransactionImpl(this, transactionId);
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextTransactionId() {
        long l = System.nanoTime();
        return l;
    }

    public String getName() {
        return this.properties.getBaseDirectory();
    }

    public void close() {
        if (this.debug) {
            DLogger.debug("NDFS:Closing file system");
        }
        this.isClosed = true;
        this.flusher.flushNow(true);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean canFlushCommittedTransaction() {
        return true;
    }

    public FileSystemProperties getProperties() {
        return this.properties;
    }

    public SyncBlockWriter getSyncWriter(NdfsFile file) {
        return this.syncWriters.getSyncWriter(file);
    }

    public void markAsCommited(NdfsTransaction transaction) {
        this.gma.merge(transaction.getTma());
        this.flusher.markAsFlushable(transaction);
    }

    public GMA getGMA() {
        return this.gma;
    }

    public void release(NdfsTransaction transaction) {
        String fullName = transaction.getTransactionFile().getFullName();
        boolean deleted = new File(fullName).delete();
        if (this.debug) {
            DLogger.debug("NDFS:transaction file " + fullName + " has been deleted : " + deleted);
        }
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public String getFileNameFromFileId(long fileId) {
        Long id = new Long(fileId);
        String fileName = this.fileNamesById.get(id);
        if (fileName != null) {
            return fileName;
        }
        Long position = this.fileNamesPositionById.get(id);
        if (position == null) {
            throw new NdfsException("File with id " + fileId + " doe snot exist in the file system " + this.getProperties().getBaseDirectory());
        }
        Bytes bytes = this.fileNames.read(position, 1024L);
        fileName = this.converter.byteArrayToString(bytes, false, position.intValue(), new ReadSize(), "name");
        this.fileNamesById.put(id, fileName);
        return fileName;
    }
}

