/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.io.SyncBlockWriter;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.tool.DLogger;

public class IOFlusher
implements Runnable {
    protected NDFS ndfs;
    protected Collection<NdfsTransaction> transactionsToFlush;
    protected boolean isFlushing;
    public static boolean debug;

    public IOFlusher(NDFS ndfs) {
        debug = NdfsConfig.debug();
        this.ndfs = ndfs;
        this.transactionsToFlush = Collections.synchronizedCollection(new ArrayList());
        this.isFlushing = false;
    }

    public void markAsFlushable(NdfsTransaction transaction) {
        this.transactionsToFlush.add(transaction);
    }

    public void run() {
        if (debug) {
            DLogger.debug(String.format("IOFlusher started for file system %s", this.ndfs.getName()));
        }
        while (!this.ndfs.isClosed()) {
            this.internalFlush();
            try {
                Thread.sleep(NdfsConfig.getTimeBetweenEachFlush());
            }
            catch (InterruptedException interruptedException) {}
        }
        if (debug) {
            DLogger.debug("IOFlusher: NDFS is closed, killing IOFlusher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush() {
        block7: {
            try {
                this.isFlushing = true;
                if (!this.ndfs.canFlushCommittedTransaction()) break block7;
                ArrayList<NdfsTransaction> transactions = new ArrayList<NdfsTransaction>();
                Collection<NdfsTransaction> collection = this.transactionsToFlush;
                synchronized (collection) {
                    transactions.addAll(this.transactionsToFlush);
                    this.transactionsToFlush.clear();
                }
                Iterator iterator = transactions.iterator();
                while (iterator.hasNext()) {
                    this.internalFlush((NdfsTransaction)iterator.next());
                }
            }
            finally {
                this.isFlushing = false;
            }
        }
    }

    private void internalFlush(NdfsTransaction transaction) {
        Map<NdfsFile, Collection<Bytes>> bytesPerFile;
        if (debug) {
            DLogger.debug(String.format("IOFlusher:Flushing transaction %d", transaction.getId()));
        }
        if ((bytesPerFile = transaction.getTma().getBlocksByFile()).isEmpty()) {
            DLogger.debug(String.format("\tIOFlusher:transaction %d is empty", transaction.getId()));
        }
        for (NdfsFile file : bytesPerFile.keySet()) {
            Collection<Bytes> bytes = bytesPerFile.get(file);
            if (debug) {
                DLogger.debug(String.format("\tIOFlusher:Flushing blocks of file fid=%d (%s), nb blocks = %d", file.getId(), file.getName(), bytes.size()));
            }
            SyncBlockWriter writer = this.ndfs.getSyncWriter(file);
            Iterator<Bytes> iterator = bytes.iterator();
            int maxBlockSize = 0x100000;
            if (!iterator.hasNext()) continue;
            Bytes b1 = iterator.next();
            Bytes b2 = null;
            while (iterator.hasNext()) {
                b2 = iterator.next();
                if (b2.getOffset() == b1.getOffset() + (long)b1.getRealSize() && b1.getRealSize() < maxBlockSize) {
                    b1.append(b2);
                    continue;
                }
                writer.writeTo(b1);
                b1 = b2;
            }
            writer.writeTo(b1);
        }
        transaction.markTransactionFileAsApplied();
        this.ndfs.release(transaction);
    }

    public void flushNow(boolean stopFlusherAfter) {
        while (this.isFlushing) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.internalFlush();
    }
}

