/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.neodatis.fs.Block;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsException;
import org.neodatis.fs.NdfsFile;
import org.neodatis.tool.DLogger;

public class BlockReader {
    protected RandomAccessFile raf;
    protected long blockId;
    protected NdfsFile file;
    protected int blockSize;

    public BlockReader(NdfsFile file) {
        this.file = file;
        this.blockSize = file.getProperties().getBlockSize();
        this.initRaf();
        this.blockId = 0L;
    }

    private void initRaf() {
        String fullName = new File(this.file.getFullName()).getAbsolutePath();
        File parentDir = new File(fullName).getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            this.raf = new RandomAccessFile(fullName, "rw");
        }
        catch (FileNotFoundException e) {
            throw new NdfsException(e);
        }
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public boolean hasNext() throws IOException {
        return (this.blockId + 1L) * (long)this.blockSize < this.raf.length();
    }

    public Block next() throws IOException {
        if (NdfsConfig.debug()) {
            DLogger.info(String.format("Reading block id %d at position %d", this.blockId, this.raf.getFilePointer()));
        }
        Block block = new Block(this.file, this.blockId);
        int size = this.raf.read(block.bytes);
        if (size != this.blockSize) {
            throw new NdfsException(String.format("Reading block id %d and its size is %d instead of %d", this.blockId, size, this.blockSize));
        }
        ++this.blockId;
        return block;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getNumberOfBlocks() throws IOException {
        return this.raf.length() / (long)this.blockSize;
    }

    public long getFileSize() throws IOException {
        return this.raf.length();
    }

    public Block readBlock(long blockIdToRead) {
        try {
            this.raf.seek(blockIdToRead * (long)this.blockSize);
            Block block = new Block(this.file, blockIdToRead);
            int size = this.raf.read(block.bytes);
            return block;
        }
        catch (NdfsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NdfsException(e);
        }
    }
}

