/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs;

import java.io.File;

public class FileSystemProperties {
    private String baseDirectory;
    private int blockSize;

    public FileSystemProperties(String baseDirectory, int blockSize) {
        File f = new File(baseDirectory);
        this.baseDirectory = f.getAbsolutePath();
        if (!f.exists()) {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            } else {
                f.mkdirs();
            }
        }
        this.blockSize = blockSize;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public String getTransactionFileName(long transactionId) {
        return String.format("%d.transaction", transactionId);
    }

    public String getTransactionDirectory(boolean full) {
        if (full) {
            return new StringBuffer(this.baseDirectory).append("/transactions").toString();
        }
        return "transactions";
    }
}

