/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.exception.BTreeNodeValidationException;
import org.neodatis.btree.impl.KeyAndValue;
import org.neodatis.btree.tool.BTreeValidator;

public abstract class AbstractBTreeNode
implements IBTreeNode {
    protected int degree;
    protected Comparable[] keys;
    protected Object[] values;
    protected int nbKeys;
    protected int nbChildren;
    protected int maxNbKeys;
    protected int maxNbChildren;
    protected transient IBTree btree;

    public AbstractBTreeNode() {
        this.btree = null;
        this.degree = -1;
        this.maxNbKeys = -1;
        this.maxNbChildren = -1;
        this.keys = null;
        this.values = null;
        this.nbKeys = 0;
        this.nbChildren = 0;
    }

    public AbstractBTreeNode(IBTree btree) {
        this.basicInit(btree);
    }

    private void basicInit(IBTree btree) {
        this.btree = btree;
        this.degree = btree.getDegree();
        this.maxNbKeys = 2 * this.degree - 1;
        this.maxNbChildren = 2 * this.degree;
        this.keys = new Comparable[this.maxNbKeys];
        this.values = new Object[this.maxNbKeys];
        this.nbKeys = 0;
        this.nbChildren = 0;
        this.init();
    }

    public abstract boolean insertKeyAndValue(Comparable var1, Object var2);

    protected abstract void init();

    public abstract IBTreeNode getChildAt(int var1, boolean var2);

    public abstract IBTreeNode getParent();

    public abstract Object getParentId();

    public abstract void setParent(IBTreeNode var1);

    public abstract boolean hasParent();

    public abstract void moveChildFromTo(int var1, int var2, boolean var3);

    public IBTreeNode extractRightPart() {
        if (!this.isFull()) {
            throw new BTreeException("extract right part called on non full node");
        }
        IBTreeNode rightPart = this.btree.buildNode();
        int j = 0;
        for (int i = this.degree; i < this.maxNbKeys; ++i) {
            rightPart.setKeyAndValueAt(this.keys[i], this.values[i], j, false, false);
            this.keys[i] = null;
            this.values[i] = null;
            rightPart.setChildAt(this, i, j, false);
            IBTreeNode c = rightPart.getChildAt(j, false);
            if (c != null) {
                c.setParent(rightPart);
            }
            this.setNullChildAt(i);
            ++j;
        }
        rightPart.setChildAt(this, this.getMaxNbChildren() - 1, j, false);
        IBTreeNode c1 = rightPart.getChildAt(j, false);
        if (c1 != null) {
            c1.setParent(rightPart);
        }
        this.setNullChildAt(this.maxNbChildren - 1);
        this.keys[this.degree - 1] = null;
        this.values[this.degree - 1] = null;
        this.nbKeys = this.degree - 1;
        int originalNbChildren = this.nbChildren;
        this.nbChildren = Math.min(this.nbChildren, this.degree);
        rightPart.setNbKeys(this.degree - 1);
        rightPart.setNbChildren(originalNbChildren - this.nbChildren);
        BTreeValidator.validateNode(this);
        BTreeValidator.validateNode(rightPart);
        BTreeValidator.checkDuplicateChildren(this, rightPart);
        return rightPart;
    }

    public IKeyAndValue getKeyAndValueAt(int index) {
        if (this.keys[index] == null && this.values[index] == null) {
            return null;
        }
        return new KeyAndValue(this.keys[index], this.values[index]);
    }

    public IKeyAndValue getLastKeyAndValue() {
        return this.getKeyAndValueAt(this.nbKeys - 1);
    }

    public Comparable getKeyAt(int index) {
        return this.keys[index];
    }

    public IKeyAndValue getMedian() {
        int medianPosition = this.degree - 1;
        return this.getKeyAndValueAt(medianPosition);
    }

    public int getPositionOfKey(Comparable key) {
        int i;
        for (i = 0; i < this.nbKeys; ++i) {
            int result = this.keys[i].compareTo(key);
            if (result == 0) {
                return i + 1;
            }
            if (result <= 0) continue;
            return -(i + 1);
        }
        return -(i + 1);
    }

    public void incrementNbChildren() {
        ++this.nbChildren;
    }

    public void incrementNbKeys() {
        ++this.nbKeys;
    }

    protected void rightShiftFrom(int position, boolean shiftChildren) {
        int i;
        if (this.isFull()) {
            throw new BTreeException("Node is full, can't right shift!");
        }
        for (i = this.nbKeys; i > position; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[position] = null;
        this.values[position] = null;
        if (shiftChildren) {
            for (i = this.nbChildren; i > position; --i) {
                this.moveChildFromTo(i - 1, i, true);
            }
            this.setNullChildAt(position);
        }
    }

    protected void leftShiftFrom(int position, boolean shiftChildren) {
        for (int i = position; i < this.nbKeys - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            if (!shiftChildren) continue;
            this.moveChildFromTo(i + 1, i, false);
        }
        this.keys[this.nbKeys - 1] = null;
        this.values[this.nbKeys - 1] = null;
        if (shiftChildren) {
            this.moveChildFromTo(this.nbKeys, this.nbKeys - 1, false);
            this.setNullChildAt(this.nbKeys);
        }
    }

    public void setKeyAndValueAt(Comparable key, Object value, int index) {
        this.keys[index] = key;
        this.values[index] = value;
    }

    public void setKeyAndValueAt(IKeyAndValue keyAndValue, int index) {
        this.setKeyAndValueAt(keyAndValue.getKey(), keyAndValue.getValue(), index);
    }

    public void setKeyAndValueAt(Comparable key, Object value, int index, boolean shiftIfAlreadyExist, boolean incrementNbKeys) {
        if (shiftIfAlreadyExist && index < this.nbKeys) {
            this.rightShiftFrom(index, true);
        }
        this.keys[index] = key;
        this.values[index] = value;
        if (incrementNbKeys) {
            ++this.nbKeys;
        }
    }

    public void setKeyAndValueAt(IKeyAndValue keyAndValue, int index, boolean shiftIfAlreadyExist, boolean incrementNbKeys) {
        this.setKeyAndValueAt(keyAndValue.getKey(), keyAndValue.getValue(), index, shiftIfAlreadyExist, incrementNbKeys);
    }

    public boolean isFull() {
        return this.nbKeys == this.maxNbKeys;
    }

    public boolean isLeaf() {
        return this.nbChildren == 0;
    }

    public void mergeWith(IBTreeNode node) {
        BTreeValidator.validateNode(this);
        BTreeValidator.validateNode(node);
        this.checkIfCanMergeWith(node);
        int j = this.nbKeys;
        for (int i = 0; i < node.getNbKeys(); ++i) {
            this.setKeyAndValueAt(node.getKeyAt(i), node.getValueAsObjectAt(i), j, false, false);
            this.setChildAt(node, i, j, false);
            ++j;
        }
        if (node.getNbChildren() > node.getNbKeys()) {
            this.setChildAt(node, node.getNbChildren() - 1, j, true);
        }
        this.nbKeys += node.getNbKeys();
        this.nbChildren += node.getNbChildren();
        BTreeValidator.validateNode(this);
    }

    private void checkIfCanMergeWith(IBTreeNode node) {
        Comparable smallestOfOther;
        Comparable greatestOfThis;
        if (this.nbKeys + node.getNbKeys() > this.maxNbKeys) {
            throw new BTreeException("Trying to merge two nodes with too many keys " + this.nbKeys + " + " + node.getNbKeys() + " > " + this.maxNbKeys);
        }
        if (this.nbKeys > 0 && (greatestOfThis = this.keys[this.nbKeys - 1]).compareTo(smallestOfOther = node.getKeyAt(0)) >= 0) {
            throw new BTreeNodeValidationException("Trying to merge two nodes that have intersections :  " + this.toString() + " / " + node);
        }
        if (this.nbKeys < this.nbChildren) {
            throw new BTreeNodeValidationException("Trying to merge two nodes where the first one has more children than keys");
        }
    }

    public void removeKeyAndValueAt(int index) {
        throw new BTreeException("Not implemented");
    }

    public IBTreeNode getLastChild() {
        return this.getChildAt(this.nbChildren - 1, true);
    }

    public IBTreeNode getLastPositionChild() {
        return this.getChildAt(this.maxNbChildren - 1, false);
    }

    public int getNbKeys() {
        return this.nbKeys;
    }

    public void setNbChildren(int nbChildren) {
        this.nbChildren = nbChildren;
    }

    public void setNbKeys(int nbKeys) {
        this.nbKeys = nbKeys;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getNbChildren() {
        return this.nbChildren;
    }

    public Object deleteKeyForLeafNode(IKeyAndValue keyAndValue) {
        int position = this.getPositionOfKey(keyAndValue.getKey());
        if (position < 0) {
            return null;
        }
        int realPosition = position - 1;
        Object value = this.values[realPosition];
        this.leftShiftFrom(realPosition, false);
        --this.nbKeys;
        BTreeValidator.validateNode(this);
        return value;
    }

    public Object deleteKeyAndValueAt(int keyIndex, boolean shiftChildren) {
        Object currentValue = this.values[keyIndex];
        this.leftShiftFrom(keyIndex, shiftChildren);
        --this.nbKeys;
        if (shiftChildren && this.nbChildren > keyIndex) {
            --this.nbChildren;
        }
        return currentValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("id=").append(this.getId()).append(" {keys(").append(this.nbKeys).append(")=(");
        for (int i = 0; i < this.nbKeys; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.keys[i]).append("/").append(this.values[i]);
        }
        buffer.append("), child(").append(this.nbChildren).append(")}");
        return buffer.toString();
    }

    public int getMaxNbChildren() {
        return this.maxNbChildren;
    }

    public void setBTree(IBTree btree) {
        this.btree = btree;
    }

    public IBTree getBTree() {
        return this.btree;
    }

    public void clear() {
        this.basicInit(this.btree);
    }
}

